/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.command.CraftingTweaksCommand;
import net.blay09.mods.craftingtweaks.compat.VanillaCraftingGridProvider;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfigData;
import net.blay09.mods.craftingtweaks.crafting.ShapedRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.crafting.ShapelessRecipeMatrixMapper;
import net.blay09.mods.craftingtweaks.network.HelloMessage;
import net.blay09.mods.craftingtweaks.network.ModNetworking;
import net.blay09.mods.craftingtweaks.registry.ConfigJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.LegacyJsonCompatLoader;
import net.blay09.mods.craftingtweaks.registry.ModFileJsonCompatLoader;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaks {
    public static final String MOD_ID = "craftingtweaks";
    public static boolean debugMode;
    public static final Logger logger;
    public static boolean isServerSideInstalled;

    public static void initialize() {
        CraftingTweaksConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.getCommands().register(CraftingTweaksCommand::register);
        Balm.addServerReloadListener((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"json_registry"), (PreparableReloadListener)new LegacyJsonCompatLoader());
        CraftingTweaksAPI.registerCraftingGridProvider(new VanillaCraftingGridProvider());
        CraftingTweaksAPI.registerRecipeMatrixMapper(ShapedRecipe.class, new ShapedRecipeMatrixMapper());
        CraftingTweaksAPI.registerRecipeMatrixMapper(ShapelessRecipe.class, new ShapelessRecipeMatrixMapper());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((Player)event.getPlayer(), (CustomPacketPayload)new HelloMessage()));
        Balm.getEvents().onEvent(ItemCraftedEvent.class, event -> {
            Player player = event.getPlayer();
            Level level = player.level();
            Container craftMatrix = event.getCraftMatrix();
            RecipeManager recipeManager = level.getRecipeManager();
            if (craftMatrix instanceof CraftingContainer) {
                CraftingContainer craftingContainer = (CraftingContainer)craftMatrix;
                Optional optionalRecipeHolder = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingContainer.asCraftInput(), level);
                optionalRecipeHolder.ifPresent(recipeHolder -> CraftingTweaksAPI.setLastCraftedRecipe(player, recipeHolder));
            }
        });
        Balm.getConfig().onConfigAvailable(CraftingTweaksConfigData.class, config -> {
            ModFileJsonCompatLoader.load();
            ConfigJsonCompatLoader.load();
        });
    }

    static {
        logger = LoggerFactory.getLogger(CraftingTweaks.class);
        isServerSideInstalled = true;
    }
}

