/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.rei;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.platform.Services;
import tfar.craftingstation.rei.SideContainerSlotAccessor;
import tfar.craftingstation.util.SideContainerWrapper;

public class CraftingStationTransferHandler
implements SimpleTransferHandler {
    private final Class<CraftingStationMenu> containerClass;
    private final CategoryIdentifier<DefaultCraftingDisplay<?>> categoryIdentifier;

    public CraftingStationTransferHandler(Class<CraftingStationMenu> containerClass, CategoryIdentifier<DefaultCraftingDisplay<?>> categoryIdentifier) {
        this.containerClass = containerClass;
        this.categoryIdentifier = categoryIdentifier;
    }

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu()) || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
        return IntStream.range(1, 10).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().getSlot(id))).collect(Collectors.toList());
    }

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
        LocalPlayer player = context.getMinecraft().player;
        ArrayList<SlotAccessor> list = new ArrayList<SlotAccessor>();
        CraftingStationMenu craftingStationMenu = (CraftingStationMenu)context.getMenu();
        for (Map.Entry<Direction, BlockEntity> entry : craftingStationMenu.blockEntityMap.entrySet()) {
            SideContainerWrapper sideContainerWrapper = Services.PLATFORM.getWrapper(entry.getValue());
            for (int i = 0; i < sideContainerWrapper.$getSlotCount(); ++i) {
                list.add(new SideContainerSlotAccessor(sideContainerWrapper, i, entry.getKey()));
            }
        }
        for (int id = 64; id < 100; ++id) {
            list.add(SlotAccessor.fromPlayerInventory((Player)player, (int)(id - 54 - 10)));
        }
        return list;
    }
}

