/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.platform.Services;

public class CraftingStationBlockEntityRenderer
implements BlockEntityRenderer<CraftingStationBlockEntity> {
    public CraftingStationBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CraftingStationBlockEntity blockEntity, float var2, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int light, int var6) {
        if (!Services.PLATFORM.getConfig().showItemsInTable() || blockEntity.input.isEmpty()) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        double height = state.hasProperty((Property)SlabBlock.TYPE) ? (state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM ? 0.5 : 1.0) : 1.0;
        double spacing = 0.189;
        double offset = 0.31;
        matrixStack.translate(0.0, 0.0625 + height, 0.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack item = blockEntity.input.getItem(j + 3 * i);
                if (item.isEmpty()) continue;
                matrixStack.pushPose();
                matrixStack.translate(0.189 * (double)i + 0.31, 0.0, 0.189 * (double)j + 0.31);
                matrixStack.scale(0.25f, 0.25f, 0.25f);
                BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(item, blockEntity.getLevel(), null, 0);
                int lightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above());
                Minecraft.getInstance().getItemRenderer().render(item, ItemDisplayContext.FIXED, false, matrixStack, iRenderTypeBuffer, lightAbove, OverlayTexture.NO_OVERLAY, bakedmodel);
                matrixStack.popPose();
            }
        }
    }
}

