/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.blockentity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import tfar.craftingstation.init.ModBlockEntityTypes;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.platform.Services;

public class CraftingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    public SimpleContainer input;
    public ResultContainer output;
    private Component customName;
    protected Direction currentContainer = Direction.DOWN;
    private final RecipeManager.CachedCheck<CraftingInput, ? extends CraftingRecipe> quickCheck;

    public CraftingStationBlockEntity(BlockPos pPos, BlockState pState) {
        super(ModBlockEntityTypes.crafting_station, pPos, pState);
        this.input = new SimpleContainer(9){

            public void setChanged() {
                super.setChanged();
                CraftingStationBlockEntity.this.setChanged();
            }

            public void fromTag(ListTag pContainerNbt, HolderLookup.Provider pRegistries) {
                this.items.clear();
                for (int i = 0; i < pContainerNbt.size(); ++i) {
                    ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)pContainerNbt.getCompound(i));
                    this.items.set(i, (Object)itemstack);
                }
            }

            public ListTag createTag(HolderLookup.Provider pLevelRegistry) {
                ListTag listtag = new ListTag();
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    ItemStack itemstack = this.getItem(i);
                    listtag.add((Object)itemstack.saveOptional(pLevelRegistry));
                }
                return listtag;
            }
        };
        this.output = new ResultContainer();
        this.quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CRAFTING);
    }

    public void setCurrentContainer(Direction currentContainer) {
        this.currentContainer = currentContainer;
        this.setChanged();
    }

    public Direction getCurrentContainer() {
        return this.currentContainer;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        ListTag compound = this.input.createTag(pRegistries);
        tag.put("inv", (Tag)compound);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)pRegistries));
        }
        tag.putInt("dir", this.currentContainer.ordinal());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        ListTag invTag = tag.getList("inv", 10);
        this.input.fromTag(invTag, pRegistries);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)pRegistries);
        }
        this.currentContainer = Direction.values()[tag.getInt("dir")];
        super.loadAdditional(tag, pRegistries);
    }

    public Component getDisplayName() {
        return this.getCustomName() != null ? this.getCustomName() : Component.translatable((String)"title.crafting_station");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new CraftingStationMenu(id, playerInventory, this.input, this.output, this.worldPosition);
    }

    public void setCustomName(Component pName) {
        this.customName = pName;
    }

    public ItemStack calcResult(@Nullable Player player) {
        if (this.level == null || this.input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        if (!this.level.isClientSide && this.level.getServer() != null) {
            RecipeManager manager = this.level.getServer().getRecipeManager();
            CraftingInput craftingInventory = CraftingInput.of((int)3, (int)3, (List)this.input.items);
            Services.PLATFORM.forgeHooks$setCraftingPlayer(player);
            Optional recipe = this.quickCheck.getRecipeFor((RecipeInput)craftingInventory, this.level);
            if (recipe.isEmpty()) {
                recipe = manager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInventory, this.level);
            }
            if (recipe.isPresent()) {
                result = ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)craftingInventory, (HolderLookup.Provider)this.level.registryAccess());
            }
            Services.PLATFORM.forgeHooks$setCraftingPlayer(null);
        }
        return result;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public void setRemoved() {
        super.setRemoved();
        this.output.setItem(0, ItemStack.EMPTY);
    }

    public void setChanged() {
        super.setChanged();
        this.output.setItem(0, this.calcResult(null));
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

