/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public final class CommonTagUtil {
    private CommonTagUtil() {
    }

    public static <T> boolean isIn(TagKey<T> tagKey, T entry) {
        return CommonTagUtil.isIn(null, tagKey, entry);
    }

    public static <T> boolean isIn(@Nullable RegistryAccess registryManager, TagKey<T> tagKey, T entry) {
        Registry registry;
        Optional maybeKey;
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(entry);
        Optional maybeRegistry = registryManager != null ? registryManager.registry(tagKey.registry()) : BuiltInRegistries.REGISTRY.getOptional(tagKey.registry().location());
        if (maybeRegistry.isPresent() && tagKey.isFor(((Registry)maybeRegistry.get()).key()) && (maybeKey = (registry = (Registry)maybeRegistry.get()).getResourceKey(entry)).isPresent()) {
            return registry.getHolderOrThrow((ResourceKey)maybeKey.get()).is(tagKey);
        }
        return false;
    }
}

