/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.sliding_door;

import com.copycatsplus.copycats.CCCopycatPartialModels;
import com.copycatsplus.copycats.content.copycat.sliding_door.CopycatSlidingDoorBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.IKineticCopycatBlockRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CopycatSlidingDoorRenderer
extends SafeBlockEntityRenderer<CopycatSlidingDoorBlockEntity>
implements IKineticCopycatBlockRenderer {
    public CopycatSlidingDoorRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CopycatSlidingDoorBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        if (!be.shouldRenderSpecial(blockState)) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)DoorBlock.FACING);
        Direction movementDirection = facing.getClockWise();
        if (blockState.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.LEFT) {
            movementDirection = movementDirection.getOpposite();
        }
        float value = be.animation().getValue(partialTicks);
        float value2 = Mth.clamp((float)(value * 10.0f), (float)0.0f, (float)1.0f);
        VertexConsumer vb = buffer.getBuffer(RenderType.translucentMovingBlock());
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)(value * value * 13.0f / 16.0f)).add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale((double)(value2 * 1.0f / 32.0f)));
        if (((SlidingDoorBlock)blockState.getBlock()).isFoldingDoor()) {
            boolean flip = blockState.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
            for (boolean left : Iterate.trueAndFalse) {
                SuperByteBuffer partial = left ^ flip ? IKineticCopycatBlockRenderer.super.getRotatedModel(CCCopycatPartialModels.FOLDING_DOOR_LEFT, be) : IKineticCopycatBlockRenderer.super.getRotatedModel(CCCopycatPartialModels.FOLDING_DOOR_RIGHT, be);
                float f = flip ? -1.0f : 1.0f;
                ((SuperByteBuffer)partial.translate(0.0f, -0.001953125f, 0.0f)).translate(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale((double)(value2 * 1.0f / 32.0f)));
                partial.rotateCentered((float)Math.PI / 180 * AngleHelper.horizontalAngle((Direction)facing.getClockWise()), Direction.UP);
                if (flip) {
                    partial.translate(0.0f, 0.0f, 1.0f);
                }
                partial.rotateYDegrees(91.0f * f * value * value);
                if (!left) {
                    ((SuperByteBuffer)partial.translate(0.0f, 0.0f, f / 2.0f)).rotateYDegrees(-181.0f * f * value * value);
                }
                if (flip) {
                    partial.translate(0.0f, 0.0f, -0.5f);
                }
                partial.light(light).renderInto(ms, vb);
            }
        } else {
            ((SuperByteBuffer)IKineticCopycatBlockRenderer.super.getRotatedModel(CCCopycatPartialModels.SLIDING_DOOR, be).translate(offset)).light(light).renderInto(ms, vb);
        }
    }
}

