/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.coolrain.mixin;

import com.leclowndu93150.coolrain.CoolRainSounds;
import com.leclowndu93150.coolrain.tags.ModTags;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class RainMixin {
    @Shadow
    private int rainSoundTime;
    @Shadow
    private Minecraft minecraft;

    @Shadow
    public abstract int getTicks();

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRain(Camera camera, CallbackInfo ci) {
        ClientLevel world = this.minecraft.level;
        if (world == null) {
            return;
        }
        float rainLevel = world.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if (rainLevel <= 0.0f) {
            return;
        }
        RandomSource random = RandomSource.create((long)((long)this.getTicks() * 312987231L));
        ClientLevel levelReader = world;
        BlockPos cameraPos = BlockPos.containing((Position)camera.getPosition());
        BlockPos soundPos = null;
        int particleCount = (int)(100.0f * rainLevel * rainLevel) / (this.minecraft.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
        for (int i = 0; i < particleCount; ++i) {
            Biome biome;
            int offsetZ;
            int offsetX = random.nextInt(21) - 10;
            BlockPos heightmapPos = levelReader.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, cameraPos.offset(offsetX, 0, offsetZ = random.nextInt(21) - 10));
            if (heightmapPos.getY() <= levelReader.getMinBuildHeight() || heightmapPos.getY() > cameraPos.getY() + 10 || heightmapPos.getY() < cameraPos.getY() - 10 || (biome = (Biome)levelReader.getBiome(heightmapPos).value()).getPrecipitationAt(heightmapPos) != Biome.Precipitation.RAIN) continue;
            soundPos = heightmapPos.below();
            if (this.minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
            double particleX = random.nextDouble();
            double particleZ = random.nextDouble();
            BlockState blockState = levelReader.getBlockState(soundPos);
            FluidState fluidState = levelReader.getFluidState(soundPos);
            VoxelShape shape = blockState.getCollisionShape((BlockGetter)levelReader, soundPos);
            double shapeHeight = shape.max(Direction.Axis.Y, particleX, particleZ);
            double fluidHeight = fluidState.getHeight((BlockGetter)levelReader, soundPos);
            double maxHeight = Math.max(shapeHeight, fluidHeight);
            ParticleOptions particleType = this.getParticleType(blockState, fluidState);
            this.minecraft.level.addParticle(particleType, (double)soundPos.getX() + particleX, (double)soundPos.getY() + maxHeight, (double)soundPos.getZ() + particleZ, 0.0, 0.0, 0.0);
        }
        if (soundPos != null && random.nextInt(3) < this.rainSoundTime++) {
            this.rainSoundTime = 0;
            BlockState blockState = levelReader.getBlockState(soundPos);
            boolean isMuffled = this.isMuffledSound((LevelReader)levelReader, soundPos, cameraPos);
            this.playRainSound(world, soundPos, blockState, random, isMuffled);
        }
        ci.cancel();
    }

    @Unique
    private ParticleOptions getParticleType(BlockState blockState, FluidState fluidState) {
        return !fluidState.is(FluidTags.LAVA) && !blockState.is(Blocks.MAGMA_BLOCK) && !CampfireBlock.isLitCampfire((BlockState)blockState) ? ParticleTypes.RAIN : ParticleTypes.SMOKE;
    }

    @Unique
    private boolean isMuffledSound(LevelReader world, BlockPos soundPos, BlockPos cameraPos) {
        return soundPos.getY() > cameraPos.getY() + 1 && world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, cameraPos).getY() > Mth.floor((float)cameraPos.getY());
    }

    @Unique
    private void playRainSound(ClientLevel world, BlockPos pos, BlockState blockState, RandomSource random, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        float volume = this.getRainSoundVolume(blockState, isMuffled);
        float pitch = this.getRainSoundPitch(blockState, random);
        boolean shouldAttenuate = this.shouldAttenuateSound(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() || sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            world.playLocalSound(pos, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            world.playLocalSound(pos, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.1f, pitch, false);
        }
        world.playLocalSound(pos, sound, SoundSource.WEATHER, volume, pitch, shouldAttenuate);
    }

    @Unique
    private SoundEvent getRainSoundForBlock(BlockState blockState) {
        if (blockState.is(Blocks.LAVA) || blockState.is(Blocks.MAGMA_BLOCK) || blockState.is(Blocks.CAMPFIRE) || blockState.is(Blocks.SOUL_CAMPFIRE) || blockState.is(ModTags.Blocks.LAVA_BLOCKS)) {
            return CoolRainSounds.RAIN_SOUNDS_LAVA.get();
        }
        if (blockState.is(Blocks.WATER) || blockState.is(ModTags.Blocks.WATER_BLOCKS)) {
            return CoolRainSounds.RAIN_SOUNDS_WATER.get();
        }
        if (blockState.is(Blocks.AMETHYST_BLOCK) || blockState.is(Blocks.AMETHYST_CLUSTER) || blockState.is(Blocks.BUDDING_AMETHYST) || blockState.is(Blocks.SMALL_AMETHYST_BUD) || blockState.is(Blocks.MEDIUM_AMETHYST_BUD) || blockState.is(Blocks.LARGE_AMETHYST_BUD) || blockState.is(ModTags.Blocks.AMETHYST_BLOCKS)) {
            return CoolRainSounds.RAIN_SOUNDS_AMETHYST.get();
        }
        if (blockState.is(Blocks.NOTE_BLOCK) || blockState.is(ModTags.Blocks.NOTEBLOCK_BLOCKS)) {
            return CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get();
        }
        if (blockState.is(ModTags.Blocks.METAL_BLOCKS) || blockState.is(ModTags.Blocks.C_METAL_BLOCKS) || blockState.is(ModTags.Blocks.C_STORAGE_BLOCKS_IRON) || blockState.is(ModTags.Blocks.C_STORAGE_BLOCKS_COPPER) || blockState.is(ModTags.Blocks.C_STORAGE_BLOCKS_GOLD) || blockState.is(ModTags.Blocks.C_STORAGE_BLOCKS_NETHERITE) || blockState.is(Blocks.IRON_BLOCK) || blockState.is(Blocks.GOLD_BLOCK) || blockState.is(Blocks.NETHERITE_BLOCK) || blockState.is(Blocks.COPPER_BLOCK) || blockState.is(Blocks.RAW_IRON_BLOCK) || blockState.is(Blocks.RAW_COPPER_BLOCK) || blockState.is(Blocks.RAW_GOLD_BLOCK) || blockState.is(Blocks.LANTERN) || blockState.is(Blocks.SOUL_LANTERN) || blockState.is(Blocks.IRON_TRAPDOOR)) {
            return CoolRainSounds.RAIN_SOUNDS_METAL.get();
        }
        if (blockState.is(ModTags.Blocks.GLASS_BLOCKS) || blockState.is(ModTags.Blocks.C_GLASS_BLOCKS) || blockState.is(ModTags.Blocks.C_GLASS_PANES) || blockState.is(ModTags.Blocks.C_ICE) || blockState.is(Blocks.GLASS) || blockState.is(Blocks.TINTED_GLASS) || blockState.is(Blocks.ICE) || blockState.is(Blocks.BLUE_ICE) || blockState.is(Blocks.PACKED_ICE)) {
            return CoolRainSounds.RAIN_SOUNDS_GLASS.get();
        }
        if (blockState.is(ModTags.Blocks.FABRIC_BLOCKS) || blockState.is(BlockTags.WOOL) || blockState.is(BlockTags.WOOL_CARPETS) || blockState.is(BlockTags.BEDS)) {
            return CoolRainSounds.RAIN_SOUNDS_FABRIC.get();
        }
        if (blockState.is(ModTags.Blocks.FOLIAGE_BLOCKS) || blockState.is(ModTags.Blocks.C_LEAVES) || blockState.is(BlockTags.LEAVES)) {
            return CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get();
        }
        return SoundEvents.WEATHER_RAIN;
    }

    @Unique
    private float getRainSoundVolume(BlockState blockState, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FABRIC.get()) {
            return 0.75f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_WATER.get()) {
            return 0.175f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get()) {
            return 0.3f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            return 0.2f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 0.2f;
        }
        if (sound == SoundEvents.WEATHER_RAIN_ABOVE) {
            return 0.1f;
        }
        if (sound == SoundEvents.WEATHER_RAIN) {
            return 0.2f;
        }
        return 0.5f;
    }

    @Unique
    private float getRainSoundPitch(BlockState blockState, RandomSource random) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get() || sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 1.0f;
        }
        if (sound == SoundEvents.WEATHER_RAIN_ABOVE) {
            return 0.75f;
        }
        if (sound == SoundEvents.WEATHER_RAIN) {
            return 1.0f;
        }
        return (float)random.nextIntBetweenInclusive(8, 12) * 0.1f;
    }

    @Unique
    private boolean shouldAttenuateSound(BlockState blockState) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        return sound != CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() && sound != CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get() && sound != SoundEvents.WEATHER_RAIN_ABOVE && sound != SoundEvents.WEATHER_RAIN;
    }
}

