/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.ui.upgrades;

import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.inventory.RoomUpgradeInventory;
import dev.compactmods.machines.client.render.ConditionalGhostSlot;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.util.SlotRangeUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

public class RoomUpgradeMenu
extends AbstractContainerMenu {
    public final String roomCode;
    public boolean showBackButton = true;
    private IItemHandler playerInvHandler;
    private IItemHandler upgradeInvHandler;
    private final SlotRange playerInvRange;

    protected RoomUpgradeMenu(int winId, Inventory playerInv, String roomCode, RoomUpgradeInventory upgradeInv) {
        super((MenuType)Rooms.Menus.ROOM_UPGRADES.get(), winId);
        this.roomCode = roomCode;
        this.playerInvHandler = new PlayerMainInvWrapper(playerInv);
        this.upgradeInvHandler = upgradeInv;
        this.playerInvRange = SlotRangeUtil.makeSlotRange("player_inv", 9, 36);
        for (int slot = 0; slot < 9; ++slot) {
            int slotX = 8 + slot * 18;
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)upgradeInv, slot, slotX, 18));
        }
        int slotY = 69;
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new ConditionalGhostSlot((Container)playerInv, j1 + l * 9 + 9, 8 + j1 * 18, l * 18 + slotY));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new ConditionalGhostSlot((Container)playerInv, i1, 8 + i1 * 18, slotY + 54 + 4));
        }
    }

    public ItemStack quickMoveStack(Player player, int pIndex) {
        Slot slot = (Slot)this.slots.get(pIndex);
        ItemStack stackToMove = slot.getItem();
        if (stackToMove.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = this.playerInvRange.slots().contains(pIndex) ? ItemHandlerHelper.insertItemStacked((IItemHandler)this.upgradeInvHandler, (ItemStack)stackToMove, (boolean)false) : ItemHandlerHelper.insertItemStacked((IItemHandler)this.playerInvHandler, (ItemStack)stackToMove, (boolean)false);
        if (remainder.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return remainder;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public static MenuProvider provider(final RoomInstance room) {
        return new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"compactmachines.ui.room_upgrades");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int winId, Inventory inventory, Player player) {
                RoomUpgradeInventory serverUpgInv = (RoomUpgradeInventory)room.getData(CMDataAttachments.UPGRADE_ITEMS);
                serverUpgInv.setRoomInstance(room);
                return new RoomUpgradeMenu(winId, inventory, room.code(), serverUpgInv);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    public static RoomUpgradeMenu createClientMenu(int id, Inventory playerInv, RegistryFriendlyByteBuf extraData) {
        boolean isIsolated = extraData.readBoolean();
        String code = extraData.readUtf();
        RoomUpgradeInventory inv = (RoomUpgradeInventory)RoomUpgradeInventory.STREAM_CODEC.decode((Object)extraData);
        RoomUpgradeMenu menu = new RoomUpgradeMenu(id, playerInv, code, inv);
        menu.setIsolated(isIsolated);
        return menu;
    }

    private void setIsolated(boolean isolated) {
        this.showBackButton = !isolated;
    }
}

