/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.data.manager;

import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.data.DataFileUtil;
import dev.compactmods.machines.data.manager.IDataFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.IOUtilities;

public class CMSingletonDataFileManager<T extends CMDataFile & CodecHolder<T>>
implements IDataFileManager<T> {
    protected final MinecraftServer server;
    private final String dataKey;
    private T instance;

    public CMSingletonDataFileManager(MinecraftServer server, String dataKey, T instance) {
        this.server = server;
        this.dataKey = dataKey;
        this.instance = instance;
    }

    public void load() {
        File file = this.instance.getDataLocation(this.server).resolve(this.dataKey + ".dat").toFile();
        if (file.exists()) {
            this.instance = (CMDataFile)DataFileUtil.loadFileWithCodec(file, ((CodecHolder)this.instance).codec());
        }
    }

    @Override
    public T data() {
        return this.instance;
    }

    private void ensureFileReady() {
        Path dir = this.instance.getDataLocation(this.server);
        DataFileUtil.ensureDirExists(dir);
    }

    @Override
    public void save() {
        if (this.instance != null) {
            this.ensureFileReady();
            CompoundTag fullData = new CompoundTag();
            fullData.putString("version", this.instance.getDataVersion());
            fullData.store("data", ((CodecHolder)this.instance).codec(), this.instance);
            try {
                IOUtilities.writeNbtCompressed((CompoundTag)fullData, (Path)this.instance.getDataLocation(this.server).resolve(this.dataKey + ".dat"));
            }
            catch (IOException e) {
                LoggingUtil.modLog().error("Failed to write data: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

