/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.dimension.MissingDimensionException;
import dev.compactmods.machines.api.room.history.RoomEntryPoint;
import dev.compactmods.machines.command.argument.Suggestors;
import dev.compactmods.machines.i18n.RoomTranslations;
import dev.compactmods.machines.room.RoomHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Logger;

public class CMTeleportSubcommand {
    private static final Logger LOGGER = LoggingUtil.modLog();

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"tp").requires(cs -> cs.hasPermission(2));
        subRoot.then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_CODES).executes(CMTeleportSubcommand::teleportExecutor));
        subRoot.then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_CODES).executes(CMTeleportSubcommand::teleportSpecificPlayer)));
        return subRoot;
    }

    private static void teleportToRoom(CommandSourceStack src, MinecraftServer server, ServerPlayer player, String roomCode) {
        CompactMachines.room((String)roomCode).ifPresentOrElse(room -> {
            try {
                RoomHelper.teleportPlayerIntoRoom(server, player, room, RoomEntryPoint.playerUsingCommand((Player)player));
            }
            catch (MissingDimensionException missingDimensionException) {
                // empty catch block
            }
        }, () -> {
            LOGGER.error("Error teleporting player into room: room not found.");
            src.sendFailure(RoomTranslations.UNKNOWN_ROOM_BY_CODE.apply(roomCode));
        });
    }

    private static int teleportExecutor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = src.getServer();
        ServerPlayer player = src.getPlayerOrException();
        String roomCode = StringArgumentType.getString(ctx, (String)"room");
        CMTeleportSubcommand.teleportToRoom(src, server, player, roomCode);
        return 0;
    }

    private static int teleportSpecificPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = src.getServer();
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        String roomCode = StringArgumentType.getString(ctx, (String)"room");
        CMTeleportSubcommand.teleportToRoom(src, server, player, roomCode);
        return 0;
    }
}

