/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Matrix4f;

public record NineSliceRenderer(ResourceLocation texture, ScreenRectangle area, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight, int cornerWidth, int cornerHeight, int edgeWidth, int edgeHeight) {
    public static Builder builder(ResourceLocation texture) {
        return new Builder(texture);
    }

    public void render(GuiGraphics graphics) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("blit setup");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = graphics.pose().last().pose();
        profiler.pop();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        profiler.push("blitting");
        int x = this.area.position().x();
        int y = this.area.position().y();
        if (this.area.width() == this.uWidth && this.area.height() == this.vHeight) {
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y, this.uOffset, this.vOffset, this.area.width(), this.area.height(), this.textureWidth, this.textureHeight);
        } else if (this.area.height() == this.vHeight) {
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y, this.uOffset, this.vOffset, this.cornerWidth, this.area.height(), this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x + this.cornerWidth, y, this.area.width() - this.edgeWidth - this.cornerWidth, this.area.height(), this.uOffset + this.cornerWidth, this.vOffset, this.uWidth - this.edgeWidth - this.cornerWidth, this.vHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x + this.area.width() - this.edgeWidth, y, this.uOffset + this.uWidth - this.edgeWidth, this.vOffset, this.edgeWidth, this.area.height(), this.textureWidth, this.textureHeight);
        } else if (this.area.width() == this.uWidth) {
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y, this.uOffset, this.vOffset, this.area.width(), this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x, y + this.cornerHeight, this.area.width(), this.area.height() - this.edgeHeight - this.cornerHeight, this.uOffset, this.vOffset + this.cornerHeight, this.uWidth, this.vHeight - this.edgeHeight - this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y + this.area.height() - this.edgeHeight, this.uOffset, this.vOffset + this.vHeight - this.edgeHeight, this.area.width(), this.edgeHeight, this.textureWidth, this.textureHeight);
        } else {
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y, this.uOffset, this.vOffset, this.cornerWidth, this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x + this.cornerWidth, y, this.area.width() - this.edgeWidth - this.cornerWidth, this.cornerHeight, this.uOffset + this.cornerWidth, this.vOffset, this.uWidth - this.edgeWidth - this.cornerWidth, this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x + this.area.width() - this.edgeWidth, y, this.uOffset + this.uWidth - this.edgeWidth, this.vOffset, this.edgeWidth, this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x, y + this.area.height() - this.edgeHeight, this.uOffset, this.vOffset + this.vHeight - this.edgeHeight, this.cornerWidth, this.edgeHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x + this.cornerWidth, y + this.area.height() - this.edgeHeight, this.area.width() - this.edgeWidth - this.cornerWidth, this.edgeHeight, this.uOffset + this.cornerWidth, this.vOffset + this.vHeight - this.edgeHeight, this.uWidth - this.edgeWidth - this.cornerWidth, this.edgeHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blit(bufferbuilder, matrix4f, x + this.area.width() - this.edgeWidth, y + this.area.height() - this.edgeHeight, this.uOffset + this.uWidth - this.edgeWidth, this.vOffset + this.vHeight - this.edgeHeight, this.edgeWidth, this.edgeHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x, y + this.cornerHeight, this.cornerWidth, this.area.height() - this.edgeHeight - this.cornerHeight, this.uOffset, this.vOffset + this.cornerHeight, this.cornerWidth, this.vHeight - this.edgeHeight - this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x + this.cornerWidth, y + this.cornerHeight, this.area.width() - this.edgeWidth - this.cornerWidth, this.area.height() - this.edgeHeight - this.cornerHeight, this.uOffset + this.cornerWidth, this.vOffset + this.cornerHeight, this.uWidth - this.edgeWidth - this.cornerWidth, this.vHeight - this.edgeHeight - this.cornerHeight, this.textureWidth, this.textureHeight);
            NineSliceRenderer.blitRepeating(bufferbuilder, matrix4f, x + this.area.width() - this.edgeWidth, y + this.cornerHeight, this.cornerWidth, this.area.height() - this.edgeHeight - this.cornerHeight, this.uOffset + this.uWidth - this.edgeWidth, this.vOffset + this.cornerHeight, this.edgeWidth, this.vHeight - this.edgeHeight - this.cornerHeight, this.textureWidth, this.textureHeight);
        }
        profiler.pop();
        profiler.push("drawing");
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        profiler.pop();
    }

    private static void blit(BufferBuilder bufferbuilder, Matrix4f matrix4f, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        bufferbuilder.addVertex(matrix4f, (float)pX, (float)pY, 0.0f).setUv((pUOffset + 0.0f) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight);
        bufferbuilder.addVertex(matrix4f, (float)pX, (float)(pY + pHeight), 0.0f).setUv((pUOffset + 0.0f) / (float)pTextureWidth, (pVOffset + (float)pHeight) / (float)pTextureHeight);
        bufferbuilder.addVertex(matrix4f, (float)(pX + pWidth), (float)(pY + pHeight), 0.0f).setUv((pUOffset + (float)pWidth) / (float)pTextureWidth, (pVOffset + (float)pHeight) / (float)pTextureHeight);
        bufferbuilder.addVertex(matrix4f, (float)(pX + pWidth), (float)pY, 0.0f).setUv((pUOffset + (float)pWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight);
    }

    private static void blitRepeating(BufferBuilder bufferbuilder, Matrix4f matrix4f, int pX, int pY, int pWidth, int pHeight, int pUOffset, int pVOffset, int pSourceWidth, int pSourceHeight, int textureWidth, int textureHeight) {
        int i = pX;
        IntIterator intiterator = NineSliceRenderer.slices(pWidth, pSourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (pSourceWidth - j) / 2;
            int l = pY;
            IntIterator intiterator1 = NineSliceRenderer.slices(pHeight, pSourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (pSourceHeight - i1) / 2;
                NineSliceRenderer.blit(bufferbuilder, matrix4f, i, l, pUOffset + k, pVOffset + j1, j, i1, textureWidth, textureHeight);
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int pTarget, int pTotal) {
        int i = Mth.positiveCeilDiv((int)pTarget, (int)pTotal);
        return new Divisor(pTarget, i);
    }

    public static class Builder {
        private final ResourceLocation texture;
        private ScreenRectangle area;
        private int sliceWidth;
        private int sliceHeight;
        private int uWidth;
        private int vHeight;
        private int uOffset;
        private int vOffset;
        private int textureWidth;
        private int textureHeight;

        private Builder(ResourceLocation texture) {
            this.texture = texture;
            this.area = ScreenRectangle.empty();
        }

        public Builder sliceSize(int width, int height) {
            this.sliceWidth = width;
            this.sliceHeight = height;
            return this;
        }

        public Builder area(int x, int y, int width, int height) {
            this.area = new ScreenRectangle(x, y, width, height);
            return this;
        }

        public Builder uv(int uWidth, int vHeight) {
            return this.uv(uWidth, vHeight, 0, 0);
        }

        private Builder uv(int uWidth, int vHeight, int uOffset, int vOffset) {
            this.uWidth = uWidth;
            this.uOffset = uOffset;
            this.vHeight = vHeight;
            this.vOffset = vOffset;
            return this;
        }

        public Builder textureSize(int width, int height) {
            this.textureWidth = width;
            this.textureHeight = height;
            return this;
        }

        public NineSliceRenderer build() {
            int cornerWidth = this.sliceWidth;
            int cornerHeight = this.sliceHeight;
            int edgeWidth = this.sliceWidth;
            int edgeHeight = this.sliceHeight;
            cornerWidth = Math.min(cornerWidth, this.area.width() / 2);
            edgeWidth = Math.min(edgeWidth, this.area.width() / 2);
            cornerHeight = Math.min(cornerHeight, this.area.height() / 2);
            edgeHeight = Math.min(edgeHeight, this.area.height() / 2);
            return new NineSliceRenderer(this.texture, this.area, this.sliceWidth, this.sliceHeight, this.uWidth, this.vHeight, this.uOffset, this.vOffset, this.textureWidth, this.textureHeight, cornerWidth, cornerHeight, edgeWidth, edgeHeight);
        }
    }
}

