/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.player;

import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.network.room.SyncRoomMetadataPacket;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerEventHandler {
    public static void registerEvents() {
        NeoForge.EVENT_BUS.addListener(PlayerEventHandler::onPlayerJoinedServer);
    }

    public static void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional currentRoom = serverPlayer.getExistingData(CMDataAttachments.CURRENT_ROOM_CODE);
            currentRoom.ifPresent(roomCode -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncRoomMetadataPacket((String)roomCode, Util.NIL_UUID), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }
}

