/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.network.room;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.network.room.InitialRoomBlockDataPacket;
import dev.compactmods.machines.room.RoomBlocks;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PlayerStartedRoomTrackingPacket(String roomCode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerStartedRoomTrackingPacket> TYPE = new CustomPacketPayload.Type(CompactMachines.modRL((String)"player_started_tracking_room"));
    public static final StreamCodec<FriendlyByteBuf, PlayerStartedRoomTrackingPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerStartedRoomTrackingPacket::roomCode, PlayerStartedRoomTrackingPacket::new);
    public static final IPayloadHandler<PlayerStartedRoomTrackingPacket> HANDLER = (pkt, ctx) -> {
        Player sender = ctx.player();
        MinecraftServer server = ctx.player().getServer();
        CompactMachines.room((String)pkt.roomCode).ifPresent(instance -> {
            try {
                StructureTemplate blocks = RoomBlocks.getInternalBlocks(server, instance).get(5L, TimeUnit.SECONDS);
                PacketDistributor.sendToPlayer((ServerPlayer)server.getPlayerList().getPlayer(sender.getUUID()), (CustomPacketPayload)new InitialRoomBlockDataPacket(blocks), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

