/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.item;

import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.machine.MachineColors;
import dev.compactmods.machines.machine.Machines;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class UnboundCompactMachineItem
extends BlockItem {
    public UnboundCompactMachineItem(Item.Properties builder) {
        super((Block)Machines.Blocks.UNBOUND_MACHINE.get(), builder);
    }

    public Component getName(ItemStack pStack) {
        return Component.translatableWithFallback((String)this.getDescriptionId(pStack), (String)"Compact Machine");
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        return Util.makeDescriptionId((String)"machine", (ResourceLocation)this.getTemplateId(stack));
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set((Supplier)CMDataComponents.ROOM_TEMPLATE_ID, (Object)RoomTemplate.NO_TEMPLATE);
        stack.set((Supplier)CMDataComponents.MACHINE_COLOR, (Object)MachineColors.WHITE);
        return stack;
    }

    private ResourceLocation getTemplateId(ItemStack stack) {
        return (ResourceLocation)stack.get((Supplier)CMDataComponents.ROOM_TEMPLATE_ID);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)Component.translatableWithFallback((String)MachineTranslations.IDs.NEW_MACHINE, (String)"New Machine"));
        if (stack.has((Supplier)CMDataComponents.ROOM_TEMPLATE_ID)) {
            Component.literal((String)((ResourceLocation)stack.get((Supplier)CMDataComponents.ROOM_TEMPLATE_ID)).toString());
        }
    }
}

