/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.block.IUnboundCompactMachineBlockEntity;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.machine.Machines;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnboundCompactMachineEntity
extends BlockEntity
implements IUnboundCompactMachineBlockEntity {
    @Nullable
    private ResourceLocation templateId = null;
    @Nullable
    private Component customName;

    public UnboundCompactMachineEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Machines.BlockEntities.UNBOUND_MACHINE.get(), pos, state);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.templateId = (ResourceLocation)components.get((Supplier)CMDataComponents.ROOM_TEMPLATE_ID);
        this.customName = (Component)components.get(DataComponents.CUSTOM_NAME);
        MachineColor desiredColor = (MachineColor)components.get((Supplier)CMDataComponents.MACHINE_COLOR);
        if (desiredColor != null) {
            this.setData(CMDataAttachments.MACHINE_COLOR, desiredColor);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)CMDataComponents.ROOM_TEMPLATE_ID, (Object)this.templateId);
        builder.set((Supplier)CMDataComponents.MACHINE_COLOR, (Object)((MachineColor)this.getData(CMDataAttachments.MACHINE_COLOR)));
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("room_template");
        tag.remove("machine_color");
        tag.remove("CustomName");
    }

    public void loadAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider holders) {
        super.loadAdditional(nbt, holders);
        if (nbt.contains("template_id")) {
            this.templateId = ResourceLocation.parse((String)nbt.getString("template_id"));
        }
        this.customName = nbt.read("CustomName", ComponentSerialization.CODEC).orElse(null);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider holders) {
        super.saveAdditional(nbt, holders);
        nbt.storeNullable("template_id", ResourceLocation.CODEC, (Object)this.templateId);
        nbt.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holders) {
        CompoundTag data = super.getUpdateTag(holders);
        this.saveAdditional(data, holders);
        return data;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.templateId = tag.read("template_id", ResourceLocation.CODEC).orElse(RoomTemplate.NO_TEMPLATE);
        this.customName = tag.read("CustomName", ComponentSerialization.CODEC).orElse(null);
    }

    public void setTemplate(ResourceLocation template) {
        this.templateId = template;
        this.setChanged();
    }

    @Nullable
    public ResourceLocation templateId() {
        return this.templateId;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }
}

