/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.block.ICompactMachineBlockEntity;
import dev.compactmods.machines.machine.MachineColors;
import dev.compactmods.machines.network.machine.MachineColorSyncPacket;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompactMachineBlock
extends Block {
    public CompactMachineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void setPlacedBy(Level level, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(level, pPos, pState, pPlacer, pStack);
        MachineColor color = (MachineColor)pStack.getOrDefault((Supplier)CMDataComponents.MACHINE_COLOR, (Object)MachineColors.WHITE);
        BlockEntity be = level.getBlockEntity(pPos);
        if (be != null) {
            be.setData(CMDataAttachments.MACHINE_COLOR, (Object)color);
        }
    }

    @NotNull
    protected static ItemInteractionResult tryDyingMachine(ServerLevel level, @NotNull BlockPos pos, Player player, DyeItem dye, ItemStack mainItem) {
        DyeColor color = dye.getDyeColor();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ICompactMachineBlockEntity) {
            MachineColor newColor = MachineColor.fromDyeColor((DyeColor)color);
            blockEntity.setData(CMDataAttachments.MACHINE_COLOR, (Object)newColor);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new MachineColorSyncPacket(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), newColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (!player.isCreative()) {
                mainItem.shrink(1);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.FAIL;
    }
}

