/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.FlwBackendXplat;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import dev.engine_room.flywheel.backend.mixin.AbstractClientPlayerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public final class ClrwlPlayerUniforms
extends UniformWriter {
    private static final int SIZE = 76;
    static final UniformBuffer BUFFER = new UniformBuffer(2, 76);

    private ClrwlPlayerUniforms() {
    }

    public static void update(RenderContext context) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            BUFFER.clear();
            return;
        }
        long ptr = BUFFER.ptr();
        PlayerInfo info = ((AbstractClientPlayerAccessor)player).flywheel$getPlayerInfo();
        Vec3 eyePos = player.getEyePosition(context.partialTick());
        ptr = ClrwlPlayerUniforms.writeVec3(ptr, (float)eyePos.x, (float)eyePos.y, (float)eyePos.z);
        ptr = ClrwlPlayerUniforms.writeTeamColor(ptr, info == null ? null : info.getTeam());
        ptr = ClrwlPlayerUniforms.writeEyeBrightness(ptr, player);
        ptr = ClrwlPlayerUniforms.writeHeldLight(ptr, player);
        ptr = ClrwlPlayerUniforms.writeEyeIn(ptr, player);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.isCrouching() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.isSleeping() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.isSwimming() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.isFallFlying() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.isShiftKeyDown() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, info == null ? 0 : info.getGameMode().getId());
        BUFFER.markDirty();
    }

    private static long writeTeamColor(long ptr, @Nullable PlayerTeam team) {
        if (team != null) {
            Integer color = team.getColor().getColor();
            if (color != null) {
                int red = FastColor.ARGB32.red((int)color);
                int green = FastColor.ARGB32.green((int)color);
                int blue = FastColor.ARGB32.blue((int)color);
                return ClrwlPlayerUniforms.writeVec4(ptr, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
            }
            return ClrwlPlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return ClrwlPlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    private static long writeEyeBrightness(long ptr, LocalPlayer player) {
        ClientLevel level = player.clientLevel;
        int blockBrightness = level.getBrightness(LightLayer.BLOCK, player.blockPosition());
        int skyBrightness = level.getBrightness(LightLayer.SKY, player.blockPosition());
        int maxBrightness = level.getMaxLightLevel();
        return ClrwlPlayerUniforms.writeVec2(ptr, (float)blockBrightness / (float)maxBrightness, (float)skyBrightness / (float)maxBrightness);
    }

    private static long writeHeldLight(long ptr, LocalPlayer player) {
        int heldLight = 0;
        for (InteractionHand hand : InteractionHand.values()) {
            BlockItem blockItem;
            Block block;
            int blockLight;
            Item handItem = player.getItemInHand(hand).getItem();
            if (!(handItem instanceof BlockItem) || heldLight >= (blockLight = FlwBackendXplat.INSTANCE.getLightEmission((block = (blockItem = (BlockItem)handItem).getBlock()).defaultBlockState(), (BlockGetter)player.clientLevel, player.blockPosition()))) continue;
            heldLight = blockLight;
        }
        return ClrwlPlayerUniforms.writeFloat(ptr, (float)heldLight / 15.0f);
    }

    private static long writeEyeIn(long ptr, LocalPlayer player) {
        ClientLevel level = player.clientLevel;
        Vec3 eyePos = player.getEyePosition();
        BlockPos blockPos = BlockPos.containing((Position)eyePos);
        return ClrwlPlayerUniforms.writeInFluidAndBlock(ptr, (Level)level, blockPos, eyePos);
    }
}

