/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import dev.djefrey.colorwheel.engine.ClrwlAbstractInstancer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.backend.engine.AbstractInstancer;
import org.jetbrains.annotations.UnknownNullability;

public class ClrwlInstanceHandle<I extends Instance>
implements InstanceHandle {
    public @UnknownNullability State<I> state;
    public int index;

    public ClrwlInstanceHandle(@UnknownNullability State<I> state) {
        this.state = state;
    }

    public void setChanged() {
        this.state = this.state.setChanged(this.index);
    }

    public void setDeleted() {
        this.state = this.state.setDeleted(this.index);
        this.clear();
    }

    public void setVisible(boolean visible) {
        this.state = this.state.setVisible(this, this.index, visible);
    }

    public boolean isVisible() {
        return this.state instanceof AbstractInstancer;
    }

    public void clear() {
        this.index = -1;
    }

    public static interface State<I extends Instance> {
        public State<I> setChanged(int var1);

        public State<I> setDeleted(int var1);

        public State<I> setVisible(ClrwlInstanceHandle<I> var1, int var2, boolean var3);
    }

    public record Deleted<I extends Instance>() implements State<I>
    {
        private static final Deleted<?> INSTANCE = new Deleted();

        public static <I extends Instance> Deleted<I> instance() {
            return INSTANCE;
        }

        @Override
        public State<I> setChanged(int index) {
            return this;
        }

        @Override
        public State<I> setDeleted(int index) {
            return this;
        }

        @Override
        public State<I> setVisible(ClrwlInstanceHandle<I> handle, int index, boolean visible) {
            return this;
        }
    }

    public record Hidden<I extends Instance>(ClrwlAbstractInstancer.Recreate<I> recreate, I instance) implements State<I>
    {
        @Override
        public State<I> setChanged(int index) {
            return this;
        }

        @Override
        public State<I> setDeleted(int index) {
            return this;
        }

        @Override
        public State<I> setVisible(ClrwlInstanceHandle<I> handle, int index, boolean visible) {
            if (!visible) {
                return this;
            }
            ClrwlAbstractInstancer<I> instancer = this.recreate.recreate();
            return instancer.revealInstance(handle, this.instance);
        }
    }
}

