/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.HitResult;

public class NoOffhandFireworksWithElytra
extends AbstractClientTweak {
    public NoOffhandFireworksWithElytra() {
        super("noOffhandFireworksWithElytra");
        Balm.getEvents().onEvent(UseItemInputEvent.class, this::onRightClick);
    }

    public void onRightClick(UseItemInputEvent event) {
        if (this.isEnabled() && event.getHand() == InteractionHand.OFF_HAND) {
            ItemStack heldItem;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || mc.hitResult == null || mc.hitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            ItemStack itemStack = heldItem = mc.player != null ? mc.player.getItemInHand(event.getHand()) : ItemStack.EMPTY;
            if (ClientTweaksConfig.isFireworkItem(heldItem)) {
                ItemStack wornChestItem;
                ItemStack itemStack2 = wornChestItem = mc.player != null ? mc.player.getItemBySlot(EquipmentSlot.CHEST) : ItemStack.EMPTY;
                if (wornChestItem.is(Items.ELYTRA) && ElytraItem.isFlyEnabled((ItemStack)wornChestItem)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.noOffhandFireworksWithElytra;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.noOffhandFireworksWithElytra = enabled;
        });
    }
}

