/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.client.UseItemInputEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class DoNotUseLastMending
extends AbstractClientTweak {
    public DoNotUseLastMending() {
        super("doNotUseLastMending");
        Balm.getEvents().onEvent(UseItemInputEvent.class, this::onRightClick);
        Balm.getEvents().onEvent(DigSpeedEvent.class, this::onDigSpeed);
    }

    public void onRightClick(UseItemInputEvent event) {
        if (this.isEnabled()) {
            Minecraft minecraft = Minecraft.getInstance();
            ItemStack heldItem = minecraft.player != null ? minecraft.player.getItemInHand(event.getHand()) : ItemStack.EMPTY;
            Registry enchantments = (Registry)minecraft.player.level().registryAccess().registry(Registries.ENCHANTMENT).orElseThrow();
            Holder.Reference mending = enchantments.getHolderOrThrow(Enchantments.MENDING);
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)mending, (ItemStack)heldItem) > 0 && heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) {
                MutableComponent chatComponent = Component.translatable((String)"chat.clienttweaks.lastMending");
                chatComponent.withStyle(ChatFormatting.RED);
                minecraft.player.displayClientMessage((Component)chatComponent, true);
                event.setCanceled(true);
            }
        }
    }

    public void onDigSpeed(DigSpeedEvent event) {
        if (this.isEnabled()) {
            ItemStack heldItem = event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
            Registry enchantments = (Registry)event.getPlayer().level().registryAccess().registry(Registries.ENCHANTMENT).orElseThrow();
            Holder.Reference mending = enchantments.getHolderOrThrow(Enchantments.MENDING);
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)mending, (ItemStack)heldItem) > 0 && heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) {
                event.setSpeedOverride(Float.valueOf(0.0f));
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.doNotUseLastMending;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.doNotUseLastMending = enabled;
        });
    }
}

