/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class AutoClimbLadder
extends AbstractClientTweak {
    public AutoClimbLadder() {
        super("autoClimbLadder");
        Balm.getEvents().onTickEvent(TickType.Client, TickPhase.Start, this::onPlayerTick);
    }

    public void onPlayerTick(Minecraft client) {
        LocalPlayer player = client.player;
        if (player != null && this.isEnabled() && player.onClimbable() && !player.isSuppressingSlidingDownLadder() && player.getXRot() <= -50.0f) {
            player.resetFallDistance();
            Vec3 motion = player.getDeltaMovement();
            player.setDeltaMovement(motion.x, (double)player.getSpeed(), motion.z);
        }
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.autoClimbLadder;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.autoClimbLadder = enabled;
        });
    }
}

