/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.client.keymappings.BalmKeyMappings;
import net.blay09.mods.balm.api.client.keymappings.KeyConflictContext;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.balm.api.event.client.KeyInputEvent;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ModKeyMappings {
    private static final Map<KeyMapping, AbstractClientTweak> toggleableTweaks = new HashMap<KeyMapping, AbstractClientTweak>();

    public static void initialize(BalmKeyMappings keyMappings, Collection<AbstractClientTweak> tweaks) {
        for (AbstractClientTweak tweak : tweaks) {
            if (!tweak.hasKeyBinding()) continue;
            KeyMapping keyBinding = keyMappings.registerKeyMapping("key.clienttweaks." + tweak.getName(), KeyConflictContext.INGAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.categories.clienttweaks");
            toggleableTweaks.put(keyBinding, tweak);
        }
        Balm.getEvents().onEvent(KeyInputEvent.class, ModKeyMappings::onKeyInput);
    }

    public static void onKeyInput(KeyInputEvent event) {
        if (event.getAction() == 1) {
            for (Map.Entry<KeyMapping, AbstractClientTweak> entry : toggleableTweaks.entrySet()) {
                if (!BalmClient.getKeyMappings().isActiveAndMatches(entry.getKey(), event.getKey(), event.getScanCode())) continue;
                ModKeyMappings.toggleTweak(entry.getValue());
            }
        }
    }

    private static void toggleTweak(AbstractClientTweak tweak) {
        tweak.setEnabled(!tweak.isEnabled());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            MutableComponent component = Component.translatable((String)("clienttweaks." + tweak.getName()), (Object[])new Object[]{Component.translatable((String)(tweak.isEnabled() ? "chat.clienttweaks.on" : "chat.clienttweaks.off"))});
            player.displayClientMessage((Component)component, true);
        }
    }
}

