/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.inventory;

import com.periut.chisel.block.ChiselGroupLookup;
import com.periut.chisel.inventory.IInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselInventory
implements IInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)61, (Object)ItemStack.EMPTY);

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.validateAndSetStack(slot, stack);
    }

    private void validateAndSetStack(int slot, ItemStack stack) {
        if (stack == null) {
            this.getItems().set(slot, (Object)ItemStack.EMPTY);
            return;
        }
        if (stack.isEmpty() || stack.getCount() <= 0) {
            this.getItems().set(slot, (Object)ItemStack.EMPTY);
        } else {
            ItemStack sanitizedStack = stack.copyWithCount(Math.max(1, Math.min(stack.getCount(), 99)));
            this.getItems().set(slot, (Object)sanitizedStack);
        }
        if (slot == 0) {
            this.refresh(this.getItem(slot).getItem());
        }
    }

    @Override
    public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            if (slot != 0 && !((ItemStack)this.inventory.get(0)).isEmpty()) {
                int inputCount = ((ItemStack)this.inventory.get(0)).getCount();
                result.setCount(Math.max(1, Math.min(result.getCount(), inputCount)));
            }
            if (result.getCount() <= 0) {
                result = ItemStack.EMPTY;
            }
            this.setChanged();
        }
        return result;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = (ItemStack)this.getItems().get(slot);
        if (stack.isEmpty() || stack.getCount() <= 0) {
            return ItemStack.EMPTY;
        }
        this.getItems().set(slot, (Object)ItemStack.EMPTY);
        return stack;
    }

    public void refresh(Item item) {
        if (!(item instanceof BlockItem)) {
            this.clearInv();
            return;
        }
        List<Item> chiselBlocks = ChiselGroupLookup.getBlocksInGroup(item);
        this.populate(chiselBlocks);
    }

    public void populate(List<Item> chiselBlocks) {
        this.clearInv();
        int baseCount = this.getItem(0).getCount();
        baseCount = Math.max(1, Math.min(baseCount, 99));
        for (int i = 0; i < 60 && i < chiselBlocks.size(); ++i) {
            this.setItem(i + 1, new ItemStack((ItemLike)chiselBlocks.get(i), baseCount));
        }
    }

    public void clearInv() {
        for (int i = 1; i < this.inventory.size(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public void sanitizeInventory() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            this.validateAndSetStack(i, stack);
        }
    }
}

