/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.cherishedworlds.mixin;

import com.illusivesoulworks.cherishedworlds.CherishedWorldsConstants;
import com.illusivesoulworks.cherishedworlds.client.favorites.FavoritesList;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorServerSelectionListEntry;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionListEntry;
import com.illusivesoulworks.cherishedworlds.mixin.core.AccessorWorldSelectionScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.world.level.storage.LevelSummary;

public class CherishedWorldsMixinHooks {
    public static boolean isNotValidSwap(ServerList serverList, int pos1, int pos2) {
        int offset = 0;
        if (pos2 >= serverList.size()) {
            offset = pos2 - serverList.size() + 1;
        } else if (pos1 >= serverList.size()) {
            offset = pos1 - serverList.size() + 1;
        }
        try {
            ServerData data1 = serverList.get(pos1 - offset);
            ServerData data2 = serverList.get(pos2 - offset);
            boolean isFavored1 = FavoritesList.contains(data1.name + data1.ip);
            boolean isFavored2 = FavoritesList.contains(data2.name + data2.ip);
            return isFavored1 && !isFavored2 || !isFavored1 && isFavored2;
        }
        catch (IndexOutOfBoundsException e) {
            CherishedWorldsConstants.LOG.error("Error trying to swap servers!", (Throwable)e);
            return false;
        }
    }

    public static void renameFavorite(String prevName, String newName) {
        if (FavoritesList.contains(prevName)) {
            FavoritesList.remove(prevName);
            FavoritesList.add(newName);
        }
    }

    public static boolean editDeleteButton(ServerSelectionList.Entry entry, boolean flag) {
        if (entry instanceof ServerSelectionList.OnlineServerEntry) {
            ServerData data = ((ServerSelectionList.OnlineServerEntry)entry).getServerData();
            return !FavoritesList.contains(data.name + data.ip);
        }
        return flag;
    }

    public static void updateServers(ServerList serverList, List<ServerSelectionList.OnlineServerEntry> onlineServers, ServerSelectionList serverSelectionList, JoinMultiplayerScreen screen) {
        int i;
        onlineServers.clear();
        ArrayList<ServerSelectionList.OnlineServerEntry> favorites = new ArrayList<ServerSelectionList.OnlineServerEntry>();
        ArrayList<ServerSelectionList.OnlineServerEntry> others = new ArrayList<ServerSelectionList.OnlineServerEntry>();
        for (i = 0; i < serverList.size(); ++i) {
            ServerData data = serverList.get(i);
            ServerSelectionList.OnlineServerEntry entry = AccessorServerSelectionListEntry.cherishedworlds$createEntry(serverSelectionList, screen, data);
            if (FavoritesList.contains(data.name + data.ip)) {
                favorites.add(entry);
                continue;
            }
            others.add(entry);
        }
        onlineServers.addAll(favorites);
        onlineServers.addAll(others);
        for (i = 0; i < onlineServers.size(); ++i) {
            serverList.replace(i, onlineServers.get(i).getServerData());
        }
    }

    public static void fillLevels(String filter, List<LevelSummary> levels, WorldSelectionList selectionList) {
        List entries = selectionList.children();
        entries.clear();
        filter = filter.toLowerCase(Locale.ROOT);
        ArrayList<LevelSummary> copy = new ArrayList<LevelSummary>(levels);
        ListIterator iter = copy.listIterator();
        ArrayList<Object> favorites = new ArrayList<Object>();
        while (iter.hasNext()) {
            LevelSummary summ = (LevelSummary)iter.next();
            if (!FavoritesList.contains(summ.getLevelId())) continue;
            favorites.add(summ);
            iter.remove();
        }
        Collections.sort(favorites);
        Collections.sort(copy);
        for (LevelSummary levelSummary : favorites) {
            if (!CherishedWorldsMixinHooks.filterAccepts(filter, levelSummary)) continue;
            WorldSelectionList worldSelectionList = selectionList;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, selectionList, levelSummary));
        }
        for (LevelSummary levelSummary : copy) {
            if (!CherishedWorldsMixinHooks.filterAccepts(filter, levelSummary)) continue;
            WorldSelectionList worldSelectionList = selectionList;
            Objects.requireNonNull(worldSelectionList);
            entries.add(new WorldSelectionList.WorldListEntry(worldSelectionList, selectionList, levelSummary));
        }
        WorldSelectionList.Entry entry = (WorldSelectionList.Entry)selectionList.getSelected();
        if (entry instanceof WorldSelectionList.WorldListEntry) {
            AccessorWorldSelectionListEntry accessorWorldSelectionListEntry = (AccessorWorldSelectionListEntry)entry;
            LevelSummary summary = accessorWorldSelectionListEntry.getWorldSummary();
            Button deleteButton = ((AccessorWorldSelectionScreen)selectionList.getScreen()).getDeleteButton();
            if (deleteButton != null && summary != null) {
                deleteButton.active = !FavoritesList.contains(summary.getLevelId());
            }
        }
    }

    private static boolean filterAccepts(String filter, LevelSummary level) {
        return level.getLevelName().toLowerCase(Locale.ROOT).contains(filter) || level.getLevelId().toLowerCase(Locale.ROOT).contains(filter);
    }
}

