/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class CableBlockEntity
extends BlockEntity {
    private boolean refreshPeripheral;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(PlatformHelper.get().createPeripheralAccess(this, x -> this.queueRefreshPeripheral()));
    private boolean refreshConnections = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this.tickToken)), this.cable, this.peripheral, this){

        @Override
        public Vec3 getPosition() {
            Direction dir = CableBlockEntity.this.getModemDirection();
            return Vec3.atCenterOf((Vec3i)(dir == null ? CableBlockEntity.this.getBlockPos() : CableBlockEntity.this.getBlockPos().relative(dir)));
        }
    };
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(this, x -> this.scheduleConnectionsChanged());

    public CableBlockEntity(BlockEntityType<? extends CableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setRemoved() {
        super.setRemoved();
        this.modem.removed();
        if (this.level == null || !this.level.isClientSide) {
            this.node.remove();
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.refreshPeripheral = true;
        this.refreshConnections = true;
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void setBlockState(BlockState state) {
        Direction direction = this.getModemDirection();
        boolean hasCable = this.hasCable();
        super.setBlockState(state);
        if (this.hasCable() != hasCable || this.getModemDirection() != direction) {
            PlatformHelper.get().invalidateComponent(this);
        }
    }

    private @Nullable Direction getModemDirection() {
        return ((CableModemVariant)((Object)this.getBlockState().getValue(CableBlock.MODEM))).getFacing();
    }

    void neighborChanged(BlockPos neighbour) {
        Direction dir = this.getModemDirection();
        if (!this.getLevel().isClientSide && dir != null && this.getBlockPos().relative(dir).equals((Object)neighbour) && this.isPeripheralOn()) {
            this.queueRefreshPeripheral();
        }
    }

    void queueRefreshPeripheral() {
        this.refreshPeripheral = true;
        this.getLevel().scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 0);
    }

    InteractionResult use(Player player) {
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        if (this.isPeripheralOn()) {
            this.detachPeripheral();
        } else {
            this.attachPeripheral();
        }
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            if (oldName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.peripheral.read(nbt, "");
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        this.peripheral.write(nbt, "");
        super.saveAdditional(nbt, registries);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        BlockState state = this.getBlockState();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.getValue(CableBlock.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheral.hasPeripheral()))) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue(CableBlock.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    void blockTick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.refreshPeripheral) {
            this.refreshPeripheral = false;
            if (this.isPeripheralOn()) {
                this.attachPeripheral();
            }
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (this.refreshConnections) {
            this.connectionsChanged();
        }
    }

    void scheduleConnectionsChanged() {
        this.refreshConnections = true;
        this.getLevel().scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 0);
    }

    void connectionsChanged() {
        if (this.getLevel().isClientSide) {
            return;
        }
        this.refreshConnections = false;
        BlockState state = this.getBlockState();
        Level world = this.getLevel();
        BlockPos current = this.getBlockPos();
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredElement element;
            BlockPos offset = current.relative(facing);
            if (!world.isLoaded(offset) || (element = this.connectedElements.get(facing)) == null) continue;
            WiredNode node = element.getNode();
            if (CableBlock.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            this.node.disconnectFrom(node);
        }
        if (!this.canAttachPeripheral()) {
            this.detachPeripheral();
        }
    }

    private void attachPeripheral() {
        Direction dir = Objects.requireNonNull(this.getModemDirection(), "Attaching without a modem");
        if (this.peripheral.attach(this.getLevel(), this.getBlockPos(), dir)) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void detachPeripheral() {
        if (this.peripheral.detach()) {
            this.updateConnectedPeripherals();
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        this.node.updatePeripherals(this.peripheral.toMap());
    }

    public @Nullable WiredElement getWiredElement(@Nullable Direction direction) {
        return direction == null || CableBlock.canConnectIn(this.getBlockState(), direction) ? this.cable : null;
    }

    public @Nullable IPeripheral getPeripheral(@Nullable Direction direction) {
        return direction == null || this.getModemDirection() == direction ? this.modem : null;
    }

    private boolean isPeripheralOn() {
        return ((CableModemVariant)((Object)this.getBlockState().getValue(CableBlock.MODEM))).isPeripheralOn();
    }

    boolean hasCable() {
        return (Boolean)this.getBlockState().getValue((Property)CableBlock.CABLE);
    }

    public boolean hasModem() {
        return this.getBlockState().getValue(CableBlock.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private final class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        public Level getLevel() {
            return CableBlockEntity.this.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.atCenterOf((Vec3i)CableBlockEntity.this.getBlockPos());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CableBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            CableBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

