/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.Coerced;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import dan200.computercraft.core.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public abstract class AbstractHandle {
    private static final int BUFFER_SIZE = 8192;
    private final SeekableByteChannel channel;
    private @Nullable TrackingCloseable closeable;
    protected final boolean binary;
    private final ByteBuffer single = ByteBuffer.allocate(1);

    protected AbstractHandle(SeekableByteChannel channel, TrackingCloseable closeable, boolean binary) {
        this.channel = channel;
        this.closeable = closeable;
        this.binary = binary;
    }

    protected void checkOpen() throws LuaException {
        TrackingCloseable closeable = this.closeable;
        if (closeable == null || !closeable.isOpen()) {
            throw new LuaException("attempt to use a closed file");
        }
    }

    @LuaFunction
    public final void close() throws LuaException {
        this.checkOpen();
        IoUtil.closeQuietly(this.closeable);
        this.closeable = null;
    }

    public Object @Nullable [] seek(Optional<String> whence, Optional<Long> offset) throws LuaException {
        this.checkOpen();
        long actualOffset = offset.orElse(0L);
        try {
            switch (whence.orElse("cur")) {
                case "set": {
                    this.channel.position(actualOffset);
                    break;
                }
                case "cur": {
                    this.channel.position(this.channel.position() + actualOffset);
                    break;
                }
                case "end": {
                    this.channel.position(this.channel.size() + actualOffset);
                    break;
                }
                default: {
                    throw new LuaException("bad argument #1 to 'seek' (invalid option '" + String.valueOf(whence) + "'");
                }
            }
            return new Object[]{this.channel.position()};
        }
        catch (IllegalArgumentException e) {
            return new Object[]{null, "Position is negative"};
        }
        catch (IOException e) {
            return null;
        }
    }

    public Object @Nullable [] read(Optional<Integer> countArg) throws LuaException {
        this.checkOpen();
        try {
            int totalRead;
            if (this.binary && countArg.isEmpty()) {
                Object[] objectArray;
                this.single.clear();
                int b = this.channel.read(this.single);
                if (b == -1) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this.single.get(0) & 0xFF;
                }
                return objectArray;
            }
            int count = countArg.orElse(1);
            if (count < 0) {
                throw new LuaException("Cannot read a negative number of bytes");
            }
            if (count == 0) {
                Object[] objectArray;
                if (this.channel.position() >= this.channel.size()) {
                    objectArray = null;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = "";
                }
                return objectArray;
            }
            if (count <= 8192) {
                ByteBuffer buffer = ByteBuffer.allocate(count);
                int read = this.channel.read(buffer);
                if (read < 0) {
                    return null;
                }
                buffer.flip();
                return new Object[]{buffer};
            }
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            int read = this.channel.read(buffer);
            if (read < 0) {
                return null;
            }
            buffer.flip();
            if (read >= count || read < 8192) {
                return new Object[]{buffer};
            }
            ArrayList<ByteBuffer> parts = new ArrayList<ByteBuffer>(4);
            parts.add(buffer);
            for (totalRead = read; read >= 8192 && totalRead < count && (read = this.channel.read(buffer = ByteBuffer.allocateDirect(Math.min(8192, count - totalRead)))) >= 0; totalRead += read) {
                buffer.flip();
                assert (read == buffer.remaining());
                parts.add(buffer);
            }
            byte[] bytes = new byte[totalRead];
            int pos = 0;
            for (ByteBuffer part : parts) {
                int length = part.remaining();
                part.get(bytes, pos, length);
                pos += length;
            }
            assert (pos == totalRead);
            return new Object[]{bytes};
        }
        catch (IOException e) {
            return null;
        }
    }

    public Object @Nullable [] readAll() throws LuaException {
        this.checkOpen();
        try {
            int expected = 32;
            expected = Math.max(expected, (int)(this.channel.size() - this.channel.position()));
            ByteArrayOutputStream stream = new ByteArrayOutputStream(expected);
            ByteBuffer buf = ByteBuffer.allocate(8192);
            while (true) {
                buf.clear();
                int r = this.channel.read(buf);
                if (r == -1) break;
                stream.write(buf.array(), 0, r);
            }
            return new Object[]{stream.toByteArray()};
        }
        catch (IOException e) {
            return null;
        }
    }

    public Object @Nullable [] readLine(Optional<Boolean> withTrailingArg) throws LuaException {
        this.checkOpen();
        boolean withTrailing = withTrailingArg.orElse(false);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            boolean readAnything = false;
            boolean readRc = false;
            while (true) {
                this.single.clear();
                int read = this.channel.read(this.single);
                if (read <= 0) {
                    Object[] objectArray;
                    if (readRc) {
                        stream.write(13);
                    }
                    if (readAnything) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = stream.toByteArray();
                    } else {
                        objectArray = null;
                    }
                    return objectArray;
                }
                readAnything = true;
                byte chr = this.single.get(0);
                if (chr == 10) {
                    if (withTrailing) {
                        if (readRc) {
                            stream.write(13);
                        }
                        stream.write(chr);
                    }
                    return new Object[]{stream.toByteArray()};
                }
                if (readRc) {
                    stream.write(13);
                }
                if (readRc = chr == 13) continue;
                stream.write(chr);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public void write(IArguments arguments) throws LuaException {
        this.checkOpen();
        try {
            Object arg = arguments.get(0);
            if (this.binary && arg instanceof Number) {
                Number n = (Number)arg;
                int number = n.intValue();
                this.writeSingle((byte)number);
            } else {
                this.channel.write(arguments.getBytesCoerced(0));
            }
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    public void writeLine(Coerced<ByteBuffer> text) throws LuaException {
        this.checkOpen();
        try {
            this.channel.write(text.value());
            this.writeSingle((byte)10);
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    private void writeSingle(byte value) throws IOException {
        this.single.clear();
        this.single.put(value);
        this.single.flip();
        this.channel.write(this.single);
    }

    public void flush() throws LuaException {
        this.checkOpen();
        try {
            SeekableByteChannel seekableByteChannel = this.channel;
            if (seekableByteChannel instanceof FileChannel) {
                FileChannel channel = (FileChannel)seekableByteChannel;
                channel.force(false);
            }
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }
}

