/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import dan200.computercraft.client.gui.ClientComputerActions;
import dan200.computercraft.client.gui.KeyConverter;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.input.UserComputerInput;
import dan200.computercraft.core.terminal.Terminal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TerminalWidget
extends AbstractWidget {
    private static final Component DESCRIPTION = Component.translatable((String)"gui.computercraft.terminal");
    private static final float TERMINATE_TIME = 0.5f;
    private static final float KEY_SUPPRESS_DELAY = 0.2f;
    private final Terminal terminal;
    private final UserComputerInput computerInput;
    private final ClientComputerActions computerActions;
    private final int innerX;
    private final int innerY;
    private final int innerWidth;
    private final int innerHeight;
    private float terminateTimer = -1.0f;
    private float rebootTimer = -1.0f;
    private float shutdownTimer = -1.0f;

    public TerminalWidget(Terminal terminal, UserComputerInput computerInput, ClientComputerActions computerActions, int x, int y) {
        super(x, y, terminal.getWidth() * 6 + 4, terminal.getHeight() * 9 + 4, DESCRIPTION);
        this.terminal = terminal;
        this.computerInput = computerInput;
        this.computerActions = computerActions;
        this.innerX = x + 2;
        this.innerY = y + 2;
        this.innerWidth = terminal.getWidth() * 6;
        this.innerHeight = terminal.getHeight() * 9;
    }

    public boolean charTyped(char ch, int modifiers) {
        this.computerInput.codepointTyped(ch);
        return true;
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 256) {
            return false;
        }
        if (Screen.isPaste((int)key)) {
            this.paste();
            return true;
        }
        if ((modifiers & 2) != 0) {
            switch (KeyConverter.physicalToActual(key, scancode)) {
                case 84: {
                    if (!(this.terminateTimer < 0.0f)) break;
                    this.terminateTimer = 0.0f;
                    break;
                }
                case 83: {
                    if (!(this.shutdownTimer < 0.0f)) break;
                    this.shutdownTimer = 0.0f;
                    break;
                }
                case 82: {
                    if (!(this.rebootTimer < 0.0f)) break;
                    this.rebootTimer = 0.0f;
                }
            }
        }
        if (key >= 0 && this.terminateTimer < 0.2f && this.rebootTimer < 0.2f && this.shutdownTimer < 0.2f) {
            this.computerInput.keyDown(key);
        }
        return true;
    }

    private void paste() {
        this.computerInput.paste(Minecraft.getInstance().keyboardHandler.getClipboard());
    }

    public boolean keyReleased(int key, int scancode, int modifiers) {
        this.computerInput.keyUp(key);
        switch (KeyConverter.physicalToActual(key, scancode)) {
            case 84: {
                this.terminateTimer = -1.0f;
                break;
            }
            case 82: {
                this.rebootTimer = -1.0f;
                break;
            }
            case 83: {
                this.shutdownTimer = -1.0f;
                break;
            }
            case 341: 
            case 345: {
                this.shutdownTimer = -1.0f;
                this.rebootTimer = -1.0f;
                this.terminateTimer = -1.0f;
            }
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        this.computerInput.mouseClick(button + 1, charX + 1, charY + 1);
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        this.computerInput.mouseUp(button + 1, charX + 1, charY + 1);
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double v2, double v3) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        this.computerInput.mouseDrag(button + 1, charX + 1, charY + 1);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.inTermRegion(mouseX, mouseY)) {
            return false;
        }
        if (deltaY == 0.0) {
            return false;
        }
        int charX = (int)((mouseX - (double)this.innerX) / 6.0);
        int charY = (int)((mouseY - (double)this.innerY) / 9.0);
        this.computerInput.mouseScroll(deltaY < 0.0 ? 1 : -1, charX + 1, charY + 1);
        return true;
    }

    private boolean inTermRegion(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.innerX && mouseY >= (double)this.innerY && mouseX < (double)(this.innerX + this.innerWidth) && mouseY < (double)(this.innerY + this.innerHeight);
    }

    public void update() {
        if (this.terminateTimer >= 0.0f && this.terminateTimer < 0.5f) {
            float f;
            this.terminateTimer += 0.05f;
            if (f > 0.5f) {
                this.computerActions.terminate();
            }
        }
        if (this.shutdownTimer >= 0.0f && this.shutdownTimer < 0.5f) {
            float f;
            this.shutdownTimer += 0.05f;
            if (f > 0.5f) {
                this.computerActions.shutdown();
            }
        }
        if (this.rebootTimer >= 0.0f && this.rebootTimer < 0.5f) {
            float f;
            this.rebootTimer += 0.05f;
            if (f > 0.5f) {
                this.computerActions.reboot();
            }
        }
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.computerInput.releaseInputs();
            this.rebootTimer = -1.0f;
            this.terminateTimer = -1.0f;
            this.shutdownTimer = -1.0f;
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        FixedWidthFontRenderer.QuadEmitter emitter = FixedWidthFontRenderer.toVertexConsumer(graphics.pose(), graphics.bufferSource().getBuffer(RenderTypes.TERMINAL));
        FixedWidthFontRenderer.drawTerminal(emitter, this.innerX, this.innerY, this.terminal, 2.0f, 2.0f, 2.0f, 2.0f);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, this.getMessage());
    }

    public static int getWidth(int termWidth) {
        return termWidth * 6 + 4;
    }

    public static int getHeight(int termHeight) {
        return termHeight * 9 + 4;
    }
}

