/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.level.ServerPlayer;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static boolean isPlayer(CommandSourceStack output) {
        ServerPlayer player = output.getPlayer();
        return player != null && !PlatformHelper.get().isFakePlayer(player);
    }

    public static CompletableFuture<Suggestions> suggestOnServer(CommandContext<?> context, Function<CommandContext<CommandSourceStack>, CompletableFuture<Suggestions>> supplier) {
        Object source = context.getSource();
        if (!(source instanceof SharedSuggestionProvider)) {
            return Suggestions.empty();
        }
        SharedSuggestionProvider shared = (SharedSuggestionProvider)source;
        if (source instanceof CommandSourceStack) {
            return supplier.apply(context);
        }
        return shared.customSuggestion(context);
    }

    public static <T> CompletableFuture<Suggestions> suggest(SuggestionsBuilder builder, Iterable<T> candidates, Function<T, String> toString) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (T choice : candidates) {
            String name = toString.apply(choice);
            if (!name.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggest(SuggestionsBuilder builder, T[] candidates, Function<T, String> toString) {
        return CommandUtils.suggest(builder, Arrays.asList(candidates), toString);
    }
}

