/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.shared.config.ConfigSpec;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class GenericSources {
    private static final Collection<GenericSource> sources = new LinkedHashSet<GenericSource>();

    private GenericSources() {
    }

    static synchronized void register(GenericSource source) {
        Objects.requireNonNull(source, "provider cannot be null");
        sources.add(source);
    }

    public static Collection<GenericMethod> getAllMethods() {
        Set disabledMethods = Set.copyOf((Collection)ConfigSpec.disabledGenericMethods.get());
        return sources.stream().filter(x -> !disabledMethods.contains(x.id())).flatMap(GenericMethod::getMethods).filter(x -> !disabledMethods.contains(x.id())).toList();
    }
}

