/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutData;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PrintoutScreen
extends AbstractContainerScreen<PrintoutMenu>
implements ContainerListener {
    private PrintoutInfo printout = PrintoutInfo.DEFAULT;
    private int page = 0;

    public PrintoutScreen(PrintoutMenu container, Inventory player, Component title) {
        super((AbstractContainerMenu)container, player, title);
        this.imageHeight = 209;
    }

    private void setPrintout(ItemStack stack) {
        this.page = 0;
        this.printout = PrintoutInfo.of(PrintoutData.getOrEmpty((DataComponentHolder)stack), stack.is((Item)ModRegistry.Items.PRINTED_BOOK.get()));
    }

    protected void init() {
        super.init();
        ((PrintoutMenu)this.menu).addSlotListener(this);
    }

    public void removed() {
        ((PrintoutMenu)this.menu).removeSlotListener(this);
    }

    public void slotChanged(AbstractContainerMenu menu, int slot, ItemStack stack) {
        if (slot == 0) {
            this.setPrintout(stack);
        }
    }

    public void dataChanged(AbstractContainerMenu menu, int slot, int data) {
        if (slot == 0) {
            this.page = data;
        }
    }

    private void setPage(int page) {
        this.page = page;
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.minecraft).gameMode);
        gameMode.handleInventoryButtonClick(((PrintoutMenu)this.menu).containerId, 100 + page);
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    private void nextPage() {
        if (this.page < this.printout.pages() - 1) {
            this.setPage(this.page + 1);
        }
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 262) {
            this.nextPage();
            return true;
        }
        if (key == 263) {
            this.previousPage();
            return true;
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public boolean mouseScrolled(double x, double y, double deltaX, double deltaY) {
        if (super.mouseScrolled(x, y, deltaX, deltaY)) {
            return true;
        }
        if (deltaY < 0.0) {
            this.nextPage();
            return true;
        }
        if (deltaY > 0.0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1.0f);
        PrintoutRenderer.drawBorder(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), this.leftPos, this.topPos, 0.0f, this.page, this.printout.pages(), this.printout.book(), 0xF000F0);
        PrintoutRenderer.drawText(graphics.pose(), (MultiBufferSource)graphics.bufferSource(), this.leftPos + 13, this.topPos + 11, 21 * this.page, 0xF000F0, this.printout.text(), this.printout.colour());
        graphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    record PrintoutInfo(int pages, boolean book, TextBuffer[] text, TextBuffer[] colour) {
        public static final PrintoutInfo DEFAULT = PrintoutInfo.of(PrintoutData.EMPTY, false);

        public static PrintoutInfo of(PrintoutData printout, boolean book) {
            TextBuffer[] text = new TextBuffer[printout.lines().size()];
            TextBuffer[] colours = new TextBuffer[printout.lines().size()];
            for (int i = 0; i < text.length; ++i) {
                PrintoutData.Line line = printout.lines().get(i);
                text[i] = new TextBuffer(line.text());
                colours[i] = new TextBuffer(line.foreground());
            }
            int pages = Math.max(text.length / 21, 1);
            return new PrintoutInfo(pages, book, text, colours);
        }
    }
}

