/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.EarthquakeAoe;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class TectonicTrembleSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"tectonic_tremble");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(1).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.range", (Object[])new Object[]{Utils.stringTruncation((double)this.getRange(spellLevel, caster), (int)0)}), Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}));
    }

    public TectonicTrembleSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 0;
        this.castTime = 15;
        this.baseManaCost = 150;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.STOMP;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        ScreenShake_Entity.ScreenShake((Level)level, (Vec3)entity.position(), (float)10.0f, (float)0.15f, (int)20, (int)20);
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate((double)this.getRange(spellLevel, entity)));
        for (LivingEntity targets : entitiesNearby) {
            boolean flag = DamageSources.applyDamage((Entity)targets, (float)this.getDamage(spellLevel, entity), (DamageSource)SpellRegistries.TECTONIC_TREMBLE.get().getDamageSource((Entity)entity));
            if (flag) {
                this.doKnockback(targets, entity, 2.0, 0.6);
            }
            targets.setRemainingFireTicks(10);
        }
        EarthquakeAoe aoe = new EarthquakeAoe(level);
        aoe.moveTo(entity.position());
        aoe.setOwner((Entity)entity);
        aoe.setCircular();
        aoe.setRadius((float)this.getRange(spellLevel, entity));
        aoe.setDuration(20);
        aoe.setDamage(0.0f);
        aoe.setSlownessAmplifier(0);
        level.addFreshEntity((Entity)aoe);
        CSUtils.spawnFlameJetWindmill(5, 3, 1.0, 1.25, 0.0, 1, entity, level, 1.0f);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), (float)this.getRange(spellLevel, entity)), (double)entity.getX(), (double)(entity.getY() + 0.5), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.9f;
    }

    private int getRange(int spellLevel, LivingEntity caster) {
        return (int)(5.0f + (float)spellLevel * this.getEntityPowerMultiplier(caster));
    }

    private void doKnockback(LivingEntity target, LivingEntity caster, double x, double y) {
        double diffX = target.getX() - caster.getX();
        double diffZ = target.getZ() - caster.getZ();
        double power = Math.max(diffX * diffX + diffZ * diffZ, 0.001);
        target.push(diffX / diffZ * x, y, diffZ / power * x);
    }
}

