/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.projectile.Blazing_Bone_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.acetheeldritchking.cataclysm_spellbooks.util.CSUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class BonePierceSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"cataclysm_spellbooks", (String)"piercing_bone");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(8).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.cataclysm_spellbooks.blazing_bone_speed", (Object[])new Object[]{Utils.stringTruncation((double)this.getBoneSpeed(0.05f, this.getSpellPower(spellLevel, (Entity)caster)), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public BonePierceSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 80;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return spellLevel;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        this.shootBone(entity, spellLevel, level);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult == RecastResult.USED_ALL_RECASTS) {
            Level level = serverPlayer.level();
            this.spreadBoneShoot((LivingEntity)serverPlayer, level);
        }
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
    }

    private void shootBone(LivingEntity caster, int spellLevel, Level level) {
        caster.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 0.75f);
        double casterX = caster.getX();
        double casterY = CSUtils.getEyeHeight(caster);
        double casterZ = caster.getZ();
        Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, this.getDamage(spellLevel, caster), caster);
        blazingBone.moveTo(casterX, casterY, casterZ, 0.0f, caster.getXRot());
        float speed = 0.05f;
        float speedSpellPower = this.getBoneSpeed(speed, this.getSpellPower(spellLevel, (Entity)caster));
        blazingBone.setNoGravity(true);
        blazingBone.shootFromRotation((Entity)caster, caster.getXRot(), caster.getYHeadRot(), 0.0f, speedSpellPower, 1.0f);
        level.addFreshEntity((Entity)blazingBone);
    }

    private void spreadBoneShoot(LivingEntity caster, Level level) {
        caster.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 0.75f);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)((double)i * Math.PI / 4.0);
            double casterX = caster.getX() + (double)Mth.cos((float)throwAngle);
            double casterY = caster.getY() + (double)caster.getBbHeight() * 0.62;
            double casterZ = caster.getZ() + (double)Mth.sin((float)throwAngle);
            double angleX = Mth.cos((float)throwAngle);
            double angleY = 0.2;
            double angleZ = Mth.sin((float)throwAngle);
            Blazing_Bone_Entity blazingBone = new Blazing_Bone_Entity(level, 3.0f, caster);
            blazingBone.moveTo(casterX, casterY, casterZ, (float)i * 45.0f, caster.getXRot());
            float speed = 0.5f;
            blazingBone.setNoGravity(true);
            blazingBone.shoot(angleX, angleY, angleZ, speed, 1.0f);
            level.addFreshEntity((Entity)blazingBone);
        }
    }

    private float getBoneSpeed(float speed, float spellPower) {
        return speed * spellPower;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster);
    }
}

