/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.items.armor;

import com.github.L_Ender.cataclysm.init.ModItems;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.acetheeldritchking.cataclysm_spellbooks.CataclysmSpellbooks;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CSArmorMaterialRegistry {
    private static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"cataclysm_spellbooks");
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> IGNITIUM_WIZARD_ARMOR = CSArmorMaterialRegistry.register("ignis_armor", CSArmorMaterialRegistry.warlockArmorMap(), 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IGNITIUM_INGOT.get()}), 3.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> ABYSSAL_WARLOCK_ARMOR = CSArmorMaterialRegistry.register("abyssal_warlock_armor", CSArmorMaterialRegistry.warlockArmorMap(), 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), 3.0f, 0.1f);
    public static DeferredHolder<ArmorMaterial, ArmorMaterial> CURSIUM_WARLOCK_ARMOR = CSArmorMaterialRegistry.register("cursium_mage_armor", CSArmorMaterialRegistry.warlockArmorMap(), 25, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MAGIC_CLOTH.get()}), 3.0f, 0.1f);

    private static DeferredHolder<ArmorMaterial, ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, float toughness, float knockbackResistance) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(CataclysmSpellbooks.id(name)));
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)defense, enchantmentValue, equipSound, repairIngredient, list, toughness, knockbackResistance));
    }

    public static EnumMap<ArmorItem.Type, Integer> makeArmorMap(int helmet, int chestplate, int leggings, int boots) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), typeIntegerEnumMap -> {
            typeIntegerEnumMap.put(ArmorItem.Type.HELMET, helmet);
            typeIntegerEnumMap.put(ArmorItem.Type.CHESTPLATE, chestplate);
            typeIntegerEnumMap.put(ArmorItem.Type.LEGGINGS, leggings);
            typeIntegerEnumMap.put(ArmorItem.Type.BOOTS, boots);
        });
    }

    public static EnumMap<ArmorItem.Type, Integer> warlockArmorMap() {
        return CSArmorMaterialRegistry.makeArmorMap(4, 9, 7, 4);
    }

    public static EnumMap<ArmorItem.Type, Integer> eldritchKingArmorMap() {
        return CSArmorMaterialRegistry.makeArmorMap(6, 11, 9, 6);
    }

    public static void register(IEventBus eventBus) {
        ARMOR_MATERIALS.register(eventBus);
    }
}

