/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.capejs.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.thestaticvoid.capejs.CapeRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerNeoForgeMixin
extends Player {
    @Shadow
    @Nullable
    private PlayerInfo playerInfo;

    @Shadow
    @Nullable
    protected abstract PlayerInfo getPlayerInfo();

    public AbstractClientPlayerNeoForgeMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Inject(method={"getSkin"}, at={@At(value="TAIL")}, cancellable=true)
    public void getSkinMixin(CallbackInfoReturnable<PlayerSkin> cir) {
        UUID playerUUID;
        PlayerInfo playerInfo = this.getPlayerInfo();
        if (playerInfo != null && CapeRegistry.mapContainsPlayer(playerUUID = playerInfo.getProfile().getId())) {
            PlayerSkin playerSkin = (PlayerSkin)cir.getReturnValue();
            cir.setReturnValue((Object)new PlayerSkin(playerSkin.texture(), playerSkin.textureUrl(), CapeRegistry.getResourceByPlayer(playerUUID), playerSkin.elytraTexture(), playerSkin.model(), playerSkin.secure()));
        }
    }
}

