/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.capejs;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.thestaticvoid.capejs.CapeJS;
import dev.thestaticvoid.capejs.kubejs.AddCapeEventJS;
import dev.thestaticvoid.capejs.kubejs.CapeJSEvents;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;

public class CapeRegistry {
    private static final HashMap<UUID, ResourceLocation> CUSTOM_CAPE_MAP = new HashMap();
    private static final ResourceLocation DEV_CAPE = CapeJS.id(CapeRegistry.locationString("dev_cape"));

    public static void initialize() {
        CapeRegistry.addCapeToMap("8c641065-dba3-41f3-864f-edea4ddfc8bb", DEV_CAPE);
        CapeJSEvents.ADD_CAPE.post((KubeEvent)new AddCapeEventJS());
    }

    private static String locationString(String type) {
        return "textures/capes/" + type + ".png";
    }

    public static ResourceLocation createCapeResource(String type) {
        String textureLocation = CapeRegistry.locationString(type);
        if (type.equals("dev_cape")) {
            throw new IllegalArgumentException("dev_cape is reserved for mod author!");
        }
        if (!ResourceLocation.isValidPath((String)textureLocation)) {
            throw new IllegalArgumentException(type + ".png is not found in capejs/textures/capes/");
        }
        return CapeJS.id(textureLocation);
    }

    public static void addCapeToMap(String uuid, ResourceLocation identifier) {
        if (!CUSTOM_CAPE_MAP.containsKey(UUID.fromString(uuid))) {
            CUSTOM_CAPE_MAP.put(UUID.fromString(uuid), identifier);
        } else {
            CapeJS.LOGGER.info("Attempted to add cape for existing UUID: {}", (Object)uuid);
        }
    }

    public static boolean mapContainsPlayer(AbstractClientPlayer player) {
        return CapeRegistry.mapContainsPlayer(player.getGameProfile().getId());
    }

    public static boolean mapContainsPlayer(UUID uuid) {
        return CUSTOM_CAPE_MAP.containsKey(uuid);
    }

    public static ResourceLocation getResourceByPlayer(AbstractClientPlayer player) {
        return CapeRegistry.getResourceByPlayer(player.getGameProfile().getId());
    }

    public static ResourceLocation getResourceByPlayer(UUID uuid) {
        if (CUSTOM_CAPE_MAP.containsKey(uuid)) {
            return CUSTOM_CAPE_MAP.get(uuid);
        }
        return null;
    }
}

