/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.networking.s2c;

import com.portingdeadmods.cable_facades.utils.ClientFacadeManager;
import com.portingdeadmods.cable_facades.utils.CodecUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AddFacadedBlocksPayload(ChunkPos chunkPos, Map<BlockPos, BlockState> facadedBlocks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AddFacadedBlocksPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cable_facades", (String)"add_facaded_blocks"));
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<BlockPos, BlockState>> FACADED_BLOCKS_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)BlockPos.STREAM_CODEC, CodecUtils.BLOCKSTATE_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, AddFacadedBlocksPayload> STREAM_CODEC = StreamCodec.composite(CodecUtils.CHUNK_POS_STREAM_CODEC, AddFacadedBlocksPayload::chunkPos, FACADED_BLOCKS_STREAM_CODEC, AddFacadedBlocksPayload::facadedBlocks, AddFacadedBlocksPayload::new);

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!ClientFacadeManager.LOADED_BLOCKS.containsKey(this.chunkPos)) {
                ClientFacadeManager.FACADED_BLOCKS.putAll(this.facadedBlocks);
                ClientFacadeManager.LOADED_BLOCKS.put(this.chunkPos, this.facadedBlocks.keySet().stream().toList());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

