/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class CableFacadesAPI {
    private static final List<String> additionalAllowedBlocks = new ArrayList<String>();
    private static final List<String> additionalDisallowedBlocks = new ArrayList<String>();
    private static final List<String> additionalZFightingBlocks = new ArrayList<String>();
    private static final List<String> additionalHiddenBlocks = new ArrayList<String>();
    private static final List<Consumer<CableFacadesAPI>> pendingCallbacks = new ArrayList<Consumer<CableFacadesAPI>>();
    private static boolean initialized = false;

    public void registerAllowedBlocks(String ... blocks) {
        additionalAllowedBlocks.addAll(Arrays.asList(blocks));
    }

    public void registerDisallowedBlocks(String ... blocks) {
        additionalDisallowedBlocks.addAll(Arrays.asList(blocks));
    }

    public void registerZFightingBlocks(String ... blocks) {
        additionalZFightingBlocks.addAll(Arrays.asList(blocks));
    }

    public void registerHiddenBlocks(String ... blocks) {
        additionalHiddenBlocks.addAll(Arrays.asList(blocks));
    }

    public static List<String> getAdditionalAllowedBlocks() {
        return additionalAllowedBlocks;
    }

    public static List<String> getAdditionalDisallowedBlocks() {
        return additionalDisallowedBlocks;
    }

    public static List<String> getAdditionalZFightingBlocks() {
        return additionalZFightingBlocks;
    }

    public static List<String> getAdditionalHiddenBlocks() {
        return additionalHiddenBlocks;
    }

    public static CableFacadesAPI getInstance() {
        if (!initialized) {
            initialized = true;
        }
        return SingletonHolder.INSTANCE;
    }

    public static void enqueueAPICallback(Consumer<CableFacadesAPI> callback) {
        if (initialized) {
            callback.accept(CableFacadesAPI.getInstance());
        } else {
            pendingCallbacks.add(callback);
        }
    }

    public static void initializeAPI() {
        initialized = true;
        pendingCallbacks.forEach(callback -> callback.accept(CableFacadesAPI.getInstance()));
        pendingCallbacks.clear();
    }

    private static class SingletonHolder {
        private static final CableFacadesAPI INSTANCE = new CableFacadesAPI();

        private SingletonHolder() {
        }
    }
}

