/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.integration.AE2Integration;
import com.direwolf20.buildinggadgets2.integration.AE2Methods;
import com.direwolf20.buildinggadgets2.integration.CuriosIntegration;
import com.direwolf20.buildinggadgets2.integration.CuriosMethods;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BuildingUtils {
    public static Level getLevel(MinecraftServer server, GlobalPos globalPos) {
        if (server == null) {
            return null;
        }
        return server.getLevel(globalPos.dimension());
    }

    public static IItemHandler getHandlerFromBound(Player player, GlobalPos boundInventory, Direction direction) {
        Level level = BuildingUtils.getLevel(player.getServer(), boundInventory);
        if (level == null) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(boundInventory.pos());
        if (blockEntity == null) {
            return null;
        }
        return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, boundInventory.pos(), (Object)direction);
    }

    public static ItemStack checkFluidHandlerForFluids(IFluidHandlerItem handler, FluidStack fluidStack, boolean simulate) {
        FluidStack drainedStack = handler.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (drainedStack.getAmount() == fluidStack.getAmount()) {
            if (!simulate) {
                handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            fluidStack.shrink(drainedStack.getAmount());
            return handler.getContainer();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack insertFluidIntoHandler(IFluidHandlerItem handler, FluidStack fluidStack, boolean simulate) {
        int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled == fluidStack.getAmount()) {
            if (!simulate) {
                handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            fluidStack.shrink(filled);
            return handler.getContainer();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack checkItemForFluids(ItemStack itemStack, FluidStack fluidStack, boolean simulate) {
        IFluidHandlerItem fluidStackCapability;
        IItemHandler itemStackCapability = (IItemHandler)itemStack.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (itemStackCapability != null) {
            BuildingUtils.checkItemHandlerForFluids(itemStackCapability, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
        }
        if ((fluidStackCapability = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM, null)) != null) {
            ItemStack returnedStack = BuildingUtils.checkFluidHandlerForFluids(fluidStackCapability, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return returnedStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack insertFluidIntoItem(ItemStack itemStack, FluidStack fluidStack, boolean simulate) {
        IFluidHandlerItem fluidStackCapability;
        IItemHandler itemStackCapability = (IItemHandler)itemStack.getCapability(Capabilities.ItemHandler.ITEM, null);
        if (itemStackCapability != null) {
            BuildingUtils.insertFluidIntoItemHandler(itemStackCapability, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return ItemStack.EMPTY;
            }
        }
        if ((fluidStackCapability = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM, null)) != null) {
            ItemStack returnedStack = BuildingUtils.insertFluidIntoHandler(fluidStackCapability, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return returnedStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack checkItemHandlerForFluids(IItemHandler handler, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            ItemStack returnedStack = BuildingUtils.checkItemForFluids(itemInSlot.copy(), fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (!simulate && !returnedStack.isEmpty()) {
                if (itemInSlot.getCount() == 1) {
                    handler.extractItem(j, 1, false);
                    handler.insertItem(j, returnedStack, false);
                } else {
                    handler.extractItem(j, 1, false);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)returnedStack, (boolean)false);
                }
            }
            return returnedStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack insertFluidIntoItemHandler(IItemHandler handler, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            ItemStack returnedStack = BuildingUtils.insertFluidIntoItem(itemInSlot.copy().split(1), fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (!simulate && !returnedStack.isEmpty()) {
                if (itemInSlot.getCount() == 1) {
                    handler.extractItem(j, 1, false);
                    handler.insertItem(j, returnedStack, false);
                } else {
                    handler.extractItem(j, 1, false);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)returnedStack, (boolean)false);
                }
            }
            return returnedStack;
        }
        return ItemStack.EMPTY;
    }

    public static void checkInventoryForFluids(Inventory inventory, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemInSlot = inventory.getItem(j);
            ItemStack returnedStack = BuildingUtils.checkItemForFluids(itemInSlot, fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (simulate || returnedStack.isEmpty()) break;
            inventory.setItem(j, returnedStack);
            break;
        }
    }

    public static boolean removeFluidStacksFromInventory(Player player, FluidStack fluidStack, boolean simulate, GlobalPos boundInventory, Direction direction) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.checkAE2ForFluids(boundInventory, player, fluidStack, simulate);
                if (fluidStack.isEmpty()) {
                    return true;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.checkItemHandlerForFluids(boundHandler, fluidStack, simulate);
            }
        }
        if (fluidStack.isEmpty()) {
            return true;
        }
        if (CuriosIntegration.isLoaded()) {
            CuriosMethods.removeFluidStacksFromInventory(player, fluidStack, simulate);
        }
        if (fluidStack.isEmpty()) {
            return true;
        }
        Inventory playerInventory = player.getInventory();
        BuildingUtils.checkInventoryForFluids(playerInventory, fluidStack, simulate);
        return fluidStack.isEmpty();
    }

    public static void checkHandlerForItems(IItemHandler handler, List<ItemStack> testArray, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            IItemHandler itemStackCapability = (IItemHandler)itemInSlot.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemStackCapability != null) {
                BuildingUtils.checkHandlerForItems(itemStackCapability, testArray, simulate);
                if (testArray.isEmpty()) {
                    break;
                }
            } else {
                Optional<ItemStack> matchStack = testArray.stream().filter(e -> ItemStack.isSameItem((ItemStack)e, (ItemStack)itemInSlot) && itemInSlot.getCount() >= e.getCount()).findFirst();
                if (matchStack.isPresent()) {
                    ItemStack matchingStack = matchStack.get();
                    handler.extractItem(j, matchingStack.getCount(), simulate);
                    testArray.remove(matchingStack);
                }
            }
            if (testArray.isEmpty()) break;
        }
    }

    public static void checkInventoryForItems(Inventory inventory, List<ItemStack> testArray, boolean simulate) {
        for (int j = 0; j < inventory.getContainerSize(); ++j) {
            ItemStack itemInSlot = inventory.getItem(j);
            IItemHandler itemStackCapability = (IItemHandler)itemInSlot.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemStackCapability != null) {
                BuildingUtils.checkHandlerForItems(itemStackCapability, testArray, simulate);
                if (testArray.isEmpty()) {
                    break;
                }
            } else {
                Optional<ItemStack> matchStack = testArray.stream().filter(e -> ItemStack.isSameItem((ItemStack)e, (ItemStack)itemInSlot) && itemInSlot.getCount() >= e.getCount()).findFirst();
                if (matchStack.isPresent()) {
                    ItemStack matchingStack = matchStack.get();
                    if (!simulate) {
                        itemInSlot.shrink(matchingStack.getCount());
                    }
                    testArray.remove(matchingStack);
                }
            }
            if (testArray.isEmpty()) break;
        }
    }

    public static boolean removeStacksFromInventory(Player player, List<ItemStack> itemStacks, boolean simulate, GlobalPos boundInventory, Direction direction) {
        if (itemStacks.isEmpty() || itemStacks.contains(Items.AIR.getDefaultInstance())) {
            return false;
        }
        ArrayList<ItemStack> testArray = new ArrayList<ItemStack>(itemStacks);
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.checkAE2ForItems(boundInventory, player, testArray, simulate);
                if (testArray.isEmpty()) {
                    return true;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.checkHandlerForItems(boundHandler, testArray, simulate);
            }
        }
        if (testArray.isEmpty()) {
            return true;
        }
        if (CuriosIntegration.isLoaded()) {
            CuriosMethods.removeStacksFromInventory(player, testArray, simulate);
        }
        if (testArray.isEmpty()) {
            return true;
        }
        Inventory playerInventory = player.getInventory();
        BuildingUtils.checkInventoryForItems(playerInventory, testArray, simulate);
        return testArray.isEmpty();
    }

    public static int countItemStacks(Player player, ItemStack itemStack) {
        if (itemStack.isEmpty() || itemStack.is(Items.AIR)) {
            return 0;
        }
        Inventory playerInventory = player.getInventory();
        int[] counter = new int[]{0};
        if (CuriosIntegration.isLoaded()) {
            CuriosMethods.countItemStacks(player, itemStack, counter);
        }
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack slotStack = playerInventory.getItem(i);
            IItemHandler itemStackCapability = (IItemHandler)slotStack.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemStackCapability != null) {
                for (int j = 0; j < itemStackCapability.getSlots(); ++j) {
                    ItemStack itemInSlot = itemStackCapability.getStackInSlot(j);
                    if (!ItemStack.isSameItem((ItemStack)itemInSlot, (ItemStack)itemStack)) continue;
                    counter[0] = counter[0] + itemInSlot.getCount();
                }
                continue;
            }
            if (!ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            counter[0] = counter[0] + slotStack.getCount();
        }
        return counter[0];
    }

    public static void giveFluidToPlayer(Player player, FluidStack returnedFluid, GlobalPos boundInventory, Direction direction) {
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.insertFluidIntoAE2(player, boundInventory, returnedFluid);
                if (returnedFluid.isEmpty()) {
                    return;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.insertFluidIntoItemHandler(boundHandler, returnedFluid, false);
            }
        }
        if (returnedFluid.isEmpty()) {
            return;
        }
        if (CuriosIntegration.isLoaded()) {
            CuriosMethods.giveFluidToPlayer(player, returnedFluid);
        }
        Inventory playerInventory = player.getInventory();
        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack slotStack = playerInventory.getItem(i);
            ItemStack returnedStack = BuildingUtils.insertFluidIntoItem(slotStack.copy().split(1), returnedFluid, false);
            if (returnedStack.isEmpty()) continue;
            if (slotStack.getCount() == 1) {
                playerInventory.setItem(i, returnedStack);
            } else {
                slotStack.shrink(1);
                if (!player.addItem(returnedStack)) {
                    BlockPos dropPos = player.getOnPos();
                    ItemEntity itementity = new ItemEntity(player.level(), (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), returnedStack);
                    itementity.setPickUpDelay(40);
                    player.level().addFreshEntity((Entity)itementity);
                }
            }
            return;
        }
    }

    public static void giveItemToPlayer(Player player, ItemStack returnedItem, GlobalPos boundInventory, Direction direction) {
        ItemStack tempReturnedItem = returnedItem.copy();
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.insertIntoAE2(player, boundInventory, tempReturnedItem);
                if (tempReturnedItem.isEmpty()) {
                    return;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                tempReturnedItem = ItemHandlerHelper.insertItemStacked((IItemHandler)boundHandler, (ItemStack)returnedItem, (boolean)false);
            }
        }
        if (tempReturnedItem.isEmpty()) {
            return;
        }
        ItemStack realReturnedItem = tempReturnedItem.copy();
        if (CuriosIntegration.isLoaded()) {
            CuriosMethods.giveItemToPlayer(player, realReturnedItem);
            if (realReturnedItem.isEmpty()) {
                return;
            }
        }
        Inventory playerInventory = player.getInventory();
        block0: for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
            ItemStack slotStack = playerInventory.getItem(i);
            IItemHandler itemStackCapability = (IItemHandler)slotStack.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemStackCapability == null) continue;
            for (int j = 0; j < itemStackCapability.getSlots(); ++j) {
                ItemStack itemInSlot = itemStackCapability.getStackInSlot(j);
                if (ItemStack.isSameItem((ItemStack)itemInSlot, (ItemStack)realReturnedItem)) {
                    itemStackCapability.insertItem(j, realReturnedItem.split(itemStackCapability.getSlotLimit(j) - itemInSlot.getCount()), false);
                }
                if (realReturnedItem.isEmpty()) continue block0;
            }
        }
        if (realReturnedItem.isEmpty()) {
            return;
        }
        if (!player.addItem(realReturnedItem)) {
            BlockPos dropPos = player.getOnPos();
            ItemEntity itementity = new ItemEntity(player.level(), (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), realReturnedItem);
            itementity.setPickUpDelay(40);
            player.level().addFreshEntity((Entity)itementity);
        }
    }

    public static int getEnergyStored(ItemStack gadget) {
        Item item = gadget.getItem();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            IEnergyStorage energy = (IEnergyStorage)gadget.getCapability(Capabilities.EnergyStorage.ITEM);
            return energy != null ? energy.getEnergyStored() : 0;
        }
        return 0;
    }

    public static int getEnergyCost(ItemStack gadget) {
        Item item = gadget.getItem();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            return baseGadget.getEnergyCost();
        }
        return -1;
    }

    public static boolean hasEnoughEnergy(ItemStack gadget) {
        int energyStored = BuildingUtils.getEnergyStored(gadget);
        int energyCost = BuildingUtils.getEnergyCost(gadget);
        return energyCost <= energyStored;
    }

    public static boolean hasEnoughEnergy(ItemStack gadget, int cost) {
        int energyStored = BuildingUtils.getEnergyStored(gadget);
        return cost <= energyStored;
    }

    public static void useEnergy(ItemStack gadget) {
        Item item = gadget.getItem();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            IEnergyStorage energy = (IEnergyStorage)gadget.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energy == null) {
                return;
            }
            int cost = baseGadget.getEnergyCost();
            energy.extractEnergy(cost, false);
        }
    }

    public static UUID build(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ItemStack gadget, boolean needItems) {
        UUID buildUUID = UUID.randomUUID();
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(level, blockPosList, lookingAt);
        GlobalPos boundPos = GadgetNBT.getBoundPos(gadget);
        int dir = boundPos == null ? -1 : GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.BIND_DIRECTION.getName());
        Direction direction = dir == -1 ? null : Direction.values()[dir];
        for (StatePos pos : blockPosList) {
            BlockPos blockPos;
            if (pos.state.isAir() || !level.mayInteract(player, (blockPos = pos.pos).offset((Vec3i)lookingAt)) || EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)blockPos.offset((Vec3i)lookingAt).below()), (Direction)Direction.UP) || !level.getBlockState(blockPos.offset((Vec3i)lookingAt)).canBeReplaced() || gadget.getItem() instanceof GadgetBuilding && needItems && !pos.state.canSurvive((LevelReader)level, blockPos.offset((Vec3i)lookingAt))) continue;
            if (pos.state.getFluidState().isEmpty()) {
                List<ItemStack> neededItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos.offset((Vec3i)lookingAt), pos.state, player);
                if (!player.isCreative() && needItems && !BuildingUtils.removeStacksFromInventory(player, neededItems, true, boundPos, direction)) {
                    continue;
                }
            } else {
                FluidState fluidState = pos.state.getFluidState();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    Fluid fluid = fluidState.getType();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    if (!player.isCreative() && needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, boundPos, direction)) continue;
                }
            }
            if (!player.isCreative() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.isCreative()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(fakeRenderingWorld.getBlockStateWithoutReal(pos.pos), pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, needItems, false, gadget, ServerBuildList.BuildType.BUILD, true, lookingAt);
        }
        return buildUUID;
    }

    public static UUID exchange(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ItemStack gadget, boolean needItems, boolean returnItems) {
        UUID buildUUID = UUID.randomUUID();
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(level, blockPosList, lookingAt);
        GlobalPos boundPos = GadgetNBT.getBoundPos(gadget);
        int dir = boundPos == null ? -1 : GadgetNBT.getToolValue(gadget, GadgetNBT.IntSettings.BIND_DIRECTION.getName());
        Direction direction = dir == -1 ? null : Direction.values()[dir];
        for (StatePos pos : blockPosList) {
            BlockEvent.BreakEvent event;
            BlockPos blockPos = pos.pos;
            if (!level.mayInteract(player, blockPos.offset((Vec3i)lookingAt)) || ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(level, blockPos.offset((Vec3i)lookingAt), level.getBlockState(blockPos.offset((Vec3i)lookingAt)), player)))).isCanceled() || EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)blockPos.offset((Vec3i)lookingAt).below()), (Direction)Direction.UP) || level.getBlockState(blockPos.offset((Vec3i)lookingAt)).equals(pos.state) || !GadgetUtils.isValidBlockState(level.getBlockState(blockPos.offset((Vec3i)lookingAt)), level, blockPos) || gadget.getItem() instanceof GadgetBuilding && needItems && !pos.state.canSurvive((LevelReader)level, blockPos.offset((Vec3i)lookingAt))) continue;
            if (pos.state.getFluidState().isEmpty()) {
                List<ItemStack> neededItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos.offset((Vec3i)lookingAt), pos.state, player);
                if (!player.isCreative() && needItems && !pos.state.isAir() && !BuildingUtils.removeStacksFromInventory(player, neededItems, true, boundPos, direction)) {
                    continue;
                }
            } else {
                FluidState fluidState = pos.state.getFluidState();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    Fluid fluid = fluidState.getType();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    if (!player.isCreative() && needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, boundPos, direction)) continue;
                }
            }
            if (!player.isCreative() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.isCreative()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(fakeRenderingWorld.getBlockStateWithoutReal(pos.pos), pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, needItems, returnItems, gadget, ServerBuildList.BuildType.EXCHANGE, true, lookingAt);
        }
        return buildUUID;
    }

    public static ArrayList<StatePos> buildWithTileData(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ArrayList<TagPos> teData, ItemStack gadget) {
        ArrayList<StatePos> actuallyBuiltList = new ArrayList<StatePos>();
        if (teData == null) {
            return actuallyBuiltList;
        }
        boolean replace = GadgetNBT.getPasteReplace(gadget);
        UUID buildUUID = !replace ? BuildingUtils.build(level, player, blockPosList, lookingAt, gadget, false) : BuildingUtils.exchange(level, player, blockPosList, lookingAt, gadget, false, false);
        ServerTickHandler.addTEData(buildUUID, teData);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        if (!bg2Data.containsUndoList(GadgetNBT.getUUID(gadget))) {
            GadgetUtils.addToUndoList(level, gadget, new ArrayList<StatePos>(), GadgetNBT.getUUID(gadget));
        }
        return actuallyBuiltList;
    }

    public static UUID removeTickHandler(Level level, Player player, List<BlockPos> blockPosList, boolean giveItem, boolean dropContents, ItemStack gadget) {
        UUID buildUUID = UUID.randomUUID();
        for (BlockPos pos : blockPosList) {
            if (!level.mayInteract(player, pos)) continue;
            if (!player.isCreative() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            BlockState oldState = level.getBlockState(pos);
            if (oldState.isAir() || !GadgetUtils.isValidBlockState(oldState, level, pos)) continue;
            if (!player.isCreative()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(Blocks.AIR.defaultBlockState(), pos), level, GadgetNBT.getRenderTypeByte(gadget), player, false, giveItem, gadget, ServerBuildList.BuildType.DESTROY, dropContents, BlockPos.ZERO);
        }
        return buildUUID;
    }
}

