/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.api.gadgets;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.direwolf20.buildinggadgets2.util.modes.BuildToMe;
import com.direwolf20.buildinggadgets2.util.modes.Copy;
import com.direwolf20.buildinggadgets2.util.modes.Cut;
import com.direwolf20.buildinggadgets2.util.modes.Grid;
import com.direwolf20.buildinggadgets2.util.modes.HorizontalRow;
import com.direwolf20.buildinggadgets2.util.modes.HorizontalWall;
import com.direwolf20.buildinggadgets2.util.modes.Paste;
import com.direwolf20.buildinggadgets2.util.modes.Stairs;
import com.direwolf20.buildinggadgets2.util.modes.Surface;
import com.direwolf20.buildinggadgets2.util.modes.VerticalColumn;
import com.direwolf20.buildinggadgets2.util.modes.VerticalWall;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;

public enum GadgetModes {
    INSTANCE;

    private final HashMap<GadgetTarget, LinkedHashSet<BaseMode>> gadgetModes = new HashMap();

    private GadgetModes() {
        this.setupDefaultModes();
    }

    private void setupDefaultModes() {
        HashMap<GadgetTarget, LinkedHashSet> modes = new HashMap<GadgetTarget, LinkedHashSet>();
        modes.put(GadgetTarget.BUILDING, new LinkedHashSet<BaseMode>(){
            {
                this.add(new BuildToMe());
                this.add(new VerticalWall());
                this.add(new VerticalColumn(false));
                this.add(new Surface(false));
                this.add(new HorizontalWall());
                this.add(new Stairs());
                this.add(new HorizontalRow(false));
                this.add(new Grid(false));
            }
        });
        modes.put(GadgetTarget.EXCHANGING, new LinkedHashSet<BaseMode>(){
            {
                this.add(new Surface(true));
                this.add(new VerticalColumn(true));
                this.add(new HorizontalRow(true));
                this.add(new Grid(true));
            }
        });
        modes.put(GadgetTarget.DESTRUCTION, new LinkedHashSet<BaseMode>(){});
        modes.put(GadgetTarget.COPYPASTE, new LinkedHashSet<BaseMode>(){
            {
                this.add(new Copy());
                this.add(new Paste());
            }
        });
        modes.put(GadgetTarget.CUTPASTE, new LinkedHashSet<BaseMode>(){
            {
                this.add(new Cut());
                this.add(new Paste());
            }
        });
        this.gadgetModes.putAll(modes);
    }

    public boolean registerMode(GadgetTarget target, BaseMode mode) {
        return this.gadgetModes.computeIfAbsent(target, key -> new LinkedHashSet()).add(mode);
    }

    public ImmutableSortedSet<BaseMode> getModesForGadget(GadgetTarget target) {
        return ImmutableSortedSet.copyOf((Collection)this.gadgetModes.computeIfAbsent(target, key -> new LinkedHashSet()));
    }
}

