/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.configurate.reference;

import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;
import de.bluecolored.shadow.configurate.ConfigurateException;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.NodePath;
import de.bluecolored.shadow.configurate.ScopedConfigurationNode;
import de.bluecolored.shadow.configurate.loader.ConfigurationLoader;
import de.bluecolored.shadow.configurate.reactive.Publisher;
import de.bluecolored.shadow.configurate.reference.ManualConfigurationReference;
import de.bluecolored.shadow.configurate.reference.ValueReference;
import de.bluecolored.shadow.configurate.reference.WatchServiceListener;
import de.bluecolored.shadow.configurate.reference.WatchingConfigurationReference;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import de.bluecolored.shadow.geantyref.TypeToken;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;

public interface ConfigurationReference<N extends ConfigurationNode>
extends AutoCloseable {
    public static <N extends ScopedConfigurationNode<N>> ConfigurationReference<N> fixed(ConfigurationLoader<? extends N> loader) throws ConfigurateException {
        ManualConfigurationReference<N> ret = new ManualConfigurationReference<N>(loader, ForkJoinPool.commonPool());
        ret.load();
        return ret;
    }

    public static <T extends ScopedConfigurationNode<T>> ConfigurationReference<T> watching(Function<Path, ConfigurationLoader<? extends T>> loaderCreator, Path file, WatchServiceListener listener) throws ConfigurateException {
        WatchingConfigurationReference<T> ret = new WatchingConfigurationReference<T>(loaderCreator.apply(file), listener.taskExecutor);
        ret.load();
        ret.disposable(listener.listenToFile(file, ret));
        return ret;
    }

    public void load() throws ConfigurateException;

    public void save() throws ConfigurateException;

    public void save(ConfigurationNode var1) throws ConfigurateException;

    public Publisher<N> saveAsync();

    public Publisher<N> updateAsync(Function<N, ? extends N> var1);

    public N node();

    public ConfigurationLoader<? extends N> loader();

    public N get(Object ... var1);

    public N get(Iterable<?> var1);

    default public void set(Object[] path, @Nullable Object value) throws SerializationException {
        this.node().node(path).set(value);
    }

    default public <T> void set(Object[] path, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> void set(Object[] path, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public void set(NodePath path, @Nullable Object value) throws SerializationException {
        this.node().node(path).set(value);
    }

    default public <T> void set(NodePath path, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> void set(NodePath path, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path).set(type, value);
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, Object ... path) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path));
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, Object ... path) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path));
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, NodePath path) throws SerializationException {
        return this.referenceTo(type, path, null);
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, NodePath path) throws SerializationException {
        return this.referenceTo(type, path, null);
    }

    public <T> ValueReference<T, N> referenceTo(TypeToken<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public <T> ValueReference<T, N> referenceTo(Class<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public Publisher<N> updates();

    public Publisher<Map.Entry<ErrorPhase, Throwable>> errors();

    @Override
    public void close();

    public static enum ErrorPhase {
        LOADING,
        SAVING,
        UNKNOWN,
        VALUE;

    }
}

