/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class ForgeWorld
implements ServerWorld {
    private final WeakReference<ServerLevel> delegate;
    private final Path worldFolder;
    private final Key dimension;

    public ForgeWorld(ServerLevel delegate) {
        this.delegate = new WeakReference<ServerLevel>(delegate);
        MinecraftServer server = delegate.getServer();
        this.worldFolder = delegate.getServer().getServerDirectory().resolve(server.getWorldPath(LevelResource.ROOT));
        ResourceLocation id = delegate.dimension().location();
        this.dimension = new Key(id.getNamespace(), id.getPath());
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        ServerLevel world = (ServerLevel)this.delegate.get();
        if (world == null) {
            return false;
        }
        CompletableFuture<Boolean> taskResult = CompletableFuture.supplyAsync(() -> {
            try {
                world.save(null, true, false);
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)world.getServer());
        try {
            return taskResult.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            throw new IOException(t2);
        }
    }

    @Override
    public Path getWorldFolder() {
        return this.worldFolder;
    }

    @Override
    public Key getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForgeWorld that = (ForgeWorld)o;
        Object world = this.delegate.get();
        return world != null && world.equals(that.delegate.get());
    }

    public int hashCode() {
        Object world = this.delegate.get();
        return world != null ? world.hashCode() : 0;
    }
}

