/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.entity.chunk;

import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.entity.chunk.MCAEntityChunk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MCAEntityChunkLoader
implements ChunkLoader<MCAEntityChunk> {
    @Override
    public MCAEntityChunk load(byte[] data, int offset, int length, Compression compression) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data, offset, length);){
            MCAEntityChunk mCAEntityChunk;
            block11: {
                InputStream decompressedIn = compression.decompress(in);
                try {
                    mCAEntityChunk = (MCAEntityChunk)MCAUtil.BLUENBT.read(decompressedIn, MCAEntityChunk.class);
                    if (decompressedIn == null) break block11;
                }
                catch (Throwable throwable) {
                    if (decompressedIn != null) {
                        try {
                            decompressedIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                decompressedIn.close();
            }
            return mCAEntityChunk;
        }
    }

    @Override
    public MCAEntityChunk emptyChunk() {
        return MCAEntityChunk.EMPTY_CHUNK;
    }

    @Override
    public MCAEntityChunk erroredChunk() {
        return MCAEntityChunk.ERRORED_CHUNK;
    }
}

