/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import com.flowpowered.math.vector.Vector2f;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public class Vector2fDeserializer
implements TypeDeserializer<Vector2f> {
    public Vector2f read(NBTReader reader) throws IOException {
        TagType tag;
        TagType tagType = tag = reader.peek();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INT_ARRAY", "LONG_ARRAY", "BYTE_ARRAY", "LIST", "COMPOUND"}, (TagType)tagType, n)) {
            case 0, 1, 2 -> {
                long[] values = reader.nextArrayAsLongArray();
                if (values.length != 2) {
                    throw new IllegalStateException("Unexpected array length: " + values.length);
                }
                yield new Vector2f((float)values[0], (float)values[1]);
            }
            case 3 -> {
                reader.beginList();
                Vector2f value = new Vector2f(reader.nextFloat(), reader.nextFloat());
                reader.endList();
                yield value;
            }
            case 4 -> {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                reader.beginCompound();
                block16: while (reader.peek() != TagType.END) {
                    switch (reader.name()) {
                        case "x": 
                        case "yaw": {
                            x = reader.nextFloat();
                            continue block16;
                        }
                        case "y": 
                        case "z": 
                        case "pitch": {
                            y = reader.nextFloat();
                            continue block16;
                        }
                    }
                    reader.skip();
                }
                reader.endCompound();
                yield new Vector2f(x, y);
            }
            default -> throw new IllegalStateException("Unexpected tag-type: " + String.valueOf(tag));
        };
    }
}

