/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.WatchService;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.ChunkGrid;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.chunk.MCAChunkLoader;
import de.bluecolored.bluemap.core.world.mca.data.DimensionTypeDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.LevelData;
import de.bluecolored.bluemap.core.world.mca.entity.chunk.MCAEntityChunk;
import de.bluecolored.bluemap.core.world.mca.entity.chunk.MCAEntityChunkLoader;
import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MCAWorld
implements World {
    private final String id;
    private final Path worldFolder;
    private final Key dimension;
    private final DataPack dataPack;
    private final LevelData levelData;
    private final DimensionType dimensionType;
    private final Vector3i spawnPoint;
    private final Path dimensionFolder;
    private final ChunkGrid<Chunk> blockChunkGrid;
    private final ChunkGrid<MCAEntityChunk> entityChunkGrid;

    private MCAWorld(Path worldFolder, Key dimension, DataPack dataPack, LevelData levelData) {
        this.id = World.id(worldFolder, dimension);
        this.worldFolder = worldFolder;
        this.dimension = dimension;
        this.dataPack = dataPack;
        this.levelData = levelData;
        LevelData.Dimension dimensionData = levelData.getData().getWorldGenSettings().getDimensions().get(dimension.getFormatted());
        if (dimensionData == null) {
            if (DataPack.DIMENSION_OVERWORLD.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.OVERWORLD);
            } else if (DataPack.DIMENSION_THE_NETHER.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.NETHER);
            } else if (DataPack.DIMENSION_THE_END.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.END);
            } else {
                Logger.global.logWarning("The level-data does not contain any dimension with the id '" + String.valueOf(dimension) + "', using fallback.");
                dimensionData = new LevelData.Dimension();
            }
        }
        this.dimensionType = dimensionData.getType();
        this.spawnPoint = new Vector3i(levelData.getData().getSpawnX(), levelData.getData().getSpawnY(), levelData.getData().getSpawnZ());
        this.dimensionFolder = MCAWorld.resolveDimensionFolder(worldFolder, dimension);
        this.blockChunkGrid = new ChunkGrid<Chunk>(new MCAChunkLoader(this), this.dimensionFolder.resolve("region"));
        this.entityChunkGrid = new ChunkGrid<MCAEntityChunk>(new MCAEntityChunkLoader(), this.dimensionFolder.resolve("entities"));
    }

    @Override
    public String getName() {
        return this.levelData.getData().getLevelName();
    }

    @Override
    public Grid getChunkGrid() {
        return this.blockChunkGrid.getChunkGrid();
    }

    @Override
    public Grid getRegionGrid() {
        return this.blockChunkGrid.getRegionGrid();
    }

    @Override
    public Chunk getChunkAtBlock(int x, int z) {
        return this.getChunk(x >> 4, z >> 4);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.blockChunkGrid.getChunk(x, z);
    }

    @Override
    public Region<Chunk> getRegion(int x, int z) {
        return this.blockChunkGrid.getRegion(x, z);
    }

    @Override
    public Collection<Vector2i> listRegions() {
        return this.blockChunkGrid.listRegions();
    }

    @Override
    public WatchService<Vector2i> createRegionWatchService() throws IOException {
        return this.blockChunkGrid.createRegionWatchService();
    }

    @Override
    public void preloadRegionChunks(int x, int z, Predicate<Vector2i> chunkFilter) {
        this.blockChunkGrid.preloadRegionChunks(x, z, chunkFilter);
        this.entityChunkGrid.preloadRegionChunks(x, z, chunkFilter);
    }

    @Override
    public void invalidateChunkCache() {
        this.blockChunkGrid.invalidateChunkCache();
        this.entityChunkGrid.invalidateChunkCache();
    }

    @Override
    public void invalidateChunkCache(int x, int z) {
        this.blockChunkGrid.invalidateChunkCache(x, z);
        this.entityChunkGrid.invalidateChunkCache(x, z);
    }

    @Override
    public void iterateEntities(int minX, int minZ, int maxX, int maxZ, Consumer<Entity> entityConsumer) {
        int minChunkX = minX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                Entity[] entities = this.entityChunkGrid.getChunk(x, z).getEntities();
                for (int i = 0; i < entities.length; ++i) {
                    Entity entity = entities[i];
                    Vector3d pos = entity.getPos();
                    int pX = pos.getFloorX();
                    int pZ = pos.getFloorZ();
                    if (pX < minX || pX > maxX || pZ < minZ || pZ > maxZ) continue;
                    entityConsumer.accept(entities[i]);
                }
            }
        }
    }

    public static MCAWorld load(Path worldFolder, Key dimension, DataPack dataPack) throws IOException, InterruptedException {
        LevelData levelData;
        Path levelFile = worldFolder.resolve("level.dat");
        BlueNBT blueNBT = MCAWorld.createBlueNBTForDataPack(dataPack);
        try (InputStream levelFileIn = Compression.GZIP.decompress(Files.newInputStream(levelFile, new OpenOption[0]));){
            levelData = (LevelData)blueNBT.read(levelFileIn, LevelData.class);
        }
        return new MCAWorld(worldFolder, dimension, dataPack, levelData);
    }

    public static Path resolveDimensionFolder(Path worldFolder, Key dimension) {
        if (DataPack.DIMENSION_OVERWORLD.equals(dimension)) {
            return worldFolder;
        }
        if (DataPack.DIMENSION_THE_NETHER.equals(dimension)) {
            return worldFolder.resolve("DIM-1");
        }
        if (DataPack.DIMENSION_THE_END.equals(dimension)) {
            return worldFolder.resolve("DIM1");
        }
        return worldFolder.resolve("dimensions").resolve(dimension.getNamespace()).resolve(dimension.getValue());
    }

    private static BlueNBT createBlueNBTForDataPack(DataPack dataPack) {
        BlueNBT blueNBT = MCAUtil.addCommonNbtSettings(new BlueNBT());
        blueNBT.register(TypeToken.of(DimensionType.class), (TypeDeserializer)new DimensionTypeDeserializer(blueNBT, dataPack));
        return blueNBT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Path getWorldFolder() {
        return this.worldFolder;
    }

    public Key getDimension() {
        return this.dimension;
    }

    public DataPack getDataPack() {
        return this.dataPack;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    @Override
    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public Vector3i getSpawnPoint() {
        return this.spawnPoint;
    }

    public Path getDimensionFolder() {
        return this.dimensionFolder;
    }

    public ChunkGrid<Chunk> getBlockChunkGrid() {
        return this.blockChunkGrid;
    }

    public ChunkGrid<MCAEntityChunk> getEntityChunkGrid() {
        return this.entityChunkGrid;
    }

    public String toString() {
        return "MCAWorld(id=" + this.getId() + ", worldFolder=" + String.valueOf(this.getWorldFolder()) + ", dimension=" + String.valueOf(this.getDimension()) + ", dataPack=" + String.valueOf(this.getDataPack()) + ", levelData=" + String.valueOf(this.getLevelData()) + ", dimensionType=" + String.valueOf(this.getDimensionType()) + ", spawnPoint=" + String.valueOf(this.getSpawnPoint()) + ", dimensionFolder=" + String.valueOf(this.getDimensionFolder()) + ", blockChunkGrid=" + String.valueOf(this.getBlockChunkGrid()) + ", entityChunkGrid=" + String.valueOf(this.getEntityChunkGrid()) + ")";
    }
}

