/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.util.Tristate;

public class BlockProperties {
    public static final BlockProperties DEFAULT = new BlockProperties();
    private Tristate culling;
    private Tristate occluding;
    private Tristate alwaysWaterlogged;
    private Tristate randomOffset;
    private Tristate cullingIdentical;

    public BlockProperties() {
        this.culling = Tristate.UNDEFINED;
        this.occluding = Tristate.UNDEFINED;
        this.alwaysWaterlogged = Tristate.UNDEFINED;
        this.randomOffset = Tristate.UNDEFINED;
        this.cullingIdentical = Tristate.UNDEFINED;
    }

    public BlockProperties(Tristate culling, Tristate occluding, Tristate alwaysWaterlogged, Tristate randomOffset, Tristate cullingIdentical) {
        this.culling = culling;
        this.occluding = occluding;
        this.alwaysWaterlogged = alwaysWaterlogged;
        this.randomOffset = randomOffset;
        this.cullingIdentical = cullingIdentical;
    }

    public boolean isCulling() {
        return this.culling.getOr(false);
    }

    public boolean isOccluding() {
        return this.occluding.getOr(false);
    }

    public boolean isAlwaysWaterlogged() {
        return this.alwaysWaterlogged.getOr(false);
    }

    public boolean isRandomOffset() {
        return this.randomOffset.getOr(false);
    }

    public boolean getCullingIdentical() {
        return this.cullingIdentical.getOr(false);
    }

    public Builder toBuilder() {
        return new BlockProperties(this.culling, this.occluding, this.alwaysWaterlogged, this.randomOffset, this.cullingIdentical).new Builder();
    }

    public static Builder builder() {
        return new BlockProperties().new Builder();
    }

    public String toString() {
        return "BlockProperties{culling=" + String.valueOf((Object)this.culling) + ", occluding=" + String.valueOf((Object)this.occluding) + ", alwaysWaterlogged=" + String.valueOf((Object)this.alwaysWaterlogged) + ", randomOffset=" + String.valueOf((Object)this.randomOffset) + ", cullingIdentical=" + String.valueOf((Object)this.cullingIdentical) + "}";
    }

    public class Builder {
        public Builder culling(boolean culling) {
            BlockProperties.this.culling = culling ? Tristate.TRUE : Tristate.FALSE;
            return this;
        }

        public Builder occluding(boolean occluding) {
            BlockProperties.this.occluding = occluding ? Tristate.TRUE : Tristate.FALSE;
            return this;
        }

        public Builder alwaysWaterlogged(boolean alwaysWaterlogged) {
            BlockProperties.this.alwaysWaterlogged = alwaysWaterlogged ? Tristate.TRUE : Tristate.FALSE;
            return this;
        }

        public Builder randomOffset(boolean randomOffset) {
            BlockProperties.this.randomOffset = randomOffset ? Tristate.TRUE : Tristate.FALSE;
            return this;
        }

        public Builder cullingIdentical(boolean cullingIdentical) {
            BlockProperties.this.cullingIdentical = cullingIdentical ? Tristate.TRUE : Tristate.FALSE;
            return this;
        }

        public Builder from(BlockProperties other) {
            BlockProperties.this.culling = other.culling.getOr(BlockProperties.this.culling);
            BlockProperties.this.occluding = other.occluding.getOr(BlockProperties.this.occluding);
            BlockProperties.this.alwaysWaterlogged = other.alwaysWaterlogged.getOr(BlockProperties.this.alwaysWaterlogged);
            BlockProperties.this.randomOffset = other.randomOffset.getOr(BlockProperties.this.randomOffset);
            BlockProperties.this.cullingIdentical = other.cullingIdentical.getOr(BlockProperties.this.cullingIdentical);
            return this;
        }

        public BlockProperties build() {
            return BlockProperties.this;
        }

        public Tristate isCulling() {
            return BlockProperties.this.culling;
        }

        public Tristate isOccluding() {
            return BlockProperties.this.occluding;
        }

        public Tristate isAlwaysWaterlogged() {
            return BlockProperties.this.alwaysWaterlogged;
        }

        public Tristate isRandomOffset() {
            return BlockProperties.this.randomOffset;
        }

        public Tristate isCullingIdentical() {
            return BlockProperties.this.cullingIdentical;
        }
    }
}

