/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.stream;

import de.bluecolored.bluemap.core.util.stream.DelegateOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CountingOutputStream
extends DelegateOutputStream {
    private long count;

    public CountingOutputStream(OutputStream out) {
        this(out, 0);
    }

    public CountingOutputStream(OutputStream out, int initialCount) {
        super(out);
        this.count = initialCount;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.count;
    }

    @Override
    public void write(byte @NotNull [] b) throws IOException {
        this.out.write(b);
        this.count += (long)b.length;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.count += (long)len;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.count = 0L;
        super.close();
    }
}

