/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.sql.PageSpliterator;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.stream.OnCloseOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public class SQLGridStorage
implements GridStorage {
    private final CommandSet sql;
    private final String map;
    private final Key storage;
    private final Compression compression;

    @Override
    public OutputStream write(int x, int z) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        return new OnCloseOutputStream(this.compression.compress(bytes), () -> this.sql.writeGridItem(this.map, this.storage, x, z, this.compression, bytes.toByteArray()));
    }

    @Override
    @Nullable
    public CompressedInputStream read(int x, int z) throws IOException {
        byte[] data = this.sql.readGridItem(this.map, this.storage, x, z, this.compression);
        if (data == null) {
            return null;
        }
        return new CompressedInputStream(new ByteArrayInputStream(data), this.compression);
    }

    @Override
    public void delete(int x, int z) throws IOException {
        this.sql.deleteGridItem(this.map, this.storage, x, z);
    }

    @Override
    public boolean exists(int x, int z) throws IOException {
        return this.sql.hasGridItem(this.map, this.storage, x, z, this.compression);
    }

    @Override
    public ItemStorage cell(int x, int z) {
        return new GridStorage.GridStorageCell(this, x, z);
    }

    @Override
    public Stream<GridStorage.Cell> stream() throws IOException {
        return StreamSupport.stream(new PageSpliterator(page -> {
            try {
                return this.sql.listGridItems(this.map, this.storage, this.compression, page * 1000, 1000);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }), false).map(tilePosition -> new GridStorage.GridStorageCell(this, tilePosition.x(), tilePosition.z()));
    }

    @Override
    public boolean isClosed() {
        return this.sql.isClosed();
    }

    public SQLGridStorage(CommandSet sql, String map, Key storage, Compression compression) {
        this.sql = sql;
        this.map = map;
        this.storage = storage;
        this.compression = compression;
    }
}

