/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Element;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Model {
    @Nullable
    private ResourcePath<Model> parent;
    private Map<String, TextureVariable> textures = new HashMap<String, TextureVariable>();
    private Element @Nullable [] elements;
    private boolean ambientocclusion = true;
    private transient boolean culling = false;
    private transient boolean occluding = false;

    private Model() {
    }

    public synchronized void optimize(ResourcePack resourcePack) {
        for (TextureVariable variable : this.textures.values()) {
            variable.optimize(resourcePack);
        }
        if (this.elements != null) {
            for (Element element : this.elements) {
                if (element == null) continue;
                element.optimize(resourcePack);
            }
        }
    }

    public synchronized void applyParent(ResourcePack resourcePack) {
        if (this.parent == null) {
            return;
        }
        ResourcePath<Model> parentPath = this.parent;
        this.parent = null;
        Model parent = parentPath.getResource(resourcePack::getModel);
        if (parent != null) {
            parent.applyParent(resourcePack);
            parent.textures.forEach(this::applyTextureVariable);
            if (this.elements == null && parent.elements != null) {
                this.elements = new Element[parent.elements.length];
                for (int i = 0; i < this.elements.length; ++i) {
                    if (parent.elements[i] == null) continue;
                    this.elements[i] = parent.elements[i].copy();
                }
            }
        }
    }

    private synchronized void applyTextureVariable(String key, TextureVariable value) {
        if (!this.textures.containsKey(key)) {
            this.textures.put(key, value.copy());
        }
    }

    public synchronized void calculateProperties(ResourcePack resourcePack) {
        if (this.elements == null) {
            return;
        }
        block0: for (Element element : this.elements) {
            if (element == null || !element.isFullCube()) continue;
            this.occluding = true;
            this.culling = true;
            for (Direction dir : Direction.values()) {
                Face face = element.getFaces().get((Object)dir);
                if (face == null) {
                    this.culling = false;
                    break block0;
                }
                ResourcePath<Texture> textureResourcePath = face.getTexture().getTexturePath(this.textures::get);
                if (textureResourcePath == null) {
                    this.culling = false;
                    break block0;
                }
                Texture texture = textureResourcePath.getResource(resourcePack::getTexture);
                if (texture != null && !(texture.getColorStraight().a < 1.0f)) continue;
                this.culling = false;
                break block0;
            }
            break;
        }
    }

    @Nullable
    public ResourcePath<Model> getParent() {
        return this.parent;
    }

    public Map<String, TextureVariable> getTextures() {
        return this.textures;
    }

    public Element @Nullable [] getElements() {
        return this.elements;
    }

    public boolean isAmbientocclusion() {
        return this.ambientocclusion;
    }

    public boolean isCulling() {
        return this.culling;
    }

    public boolean isOccluding() {
        return this.occluding;
    }
}

