/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector4f;
import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Rotation;
import de.bluecolored.bluemap.core.util.Direction;
import java.io.IOException;
import java.util.EnumMap;

@JsonAdapter(value=Adapter.class)
public class Element {
    private static final Vector3f FULL_BLOCK_MIN = Vector3f.ZERO;
    private static final Vector3f FULL_BLOCK_MAX = new Vector3f(16.0f, 16.0f, 16.0f);
    private Vector3f from = FULL_BLOCK_MIN;
    private Vector3f to = FULL_BLOCK_MAX;
    private Rotation rotation = Rotation.ZERO;
    private boolean shade = true;
    private int lightEmission = 0;
    private EnumMap<Direction, Face> faces = new EnumMap(Direction.class);

    private Element() {
    }

    private Element(Element copyFrom) {
        this.from = copyFrom.from;
        this.to = copyFrom.to;
        this.rotation = copyFrom.rotation;
        this.shade = copyFrom.shade;
        this.lightEmission = copyFrom.lightEmission;
        copyFrom.faces.forEach((direction, face) -> this.faces.put((Direction)((Object)direction), face.copy()));
    }

    private void init() {
        this.faces.forEach((direction, face) -> face.init((Direction)((Object)direction), this::calculateDefaultUV, this::calculateDefaultCullface));
    }

    private Vector4f calculateDefaultUV(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> new Vector4f(this.from.getX(), this.from.getZ(), this.to.getX(), this.to.getZ());
            case Direction.NORTH, Direction.SOUTH -> new Vector4f(this.from.getX(), this.from.getY(), this.to.getX(), this.to.getY());
            case Direction.WEST, Direction.EAST -> new Vector4f(this.from.getZ(), this.from.getY(), this.to.getZ(), this.to.getY());
        };
    }

    private Direction calculateDefaultCullface(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (this.from.getY() == 0.0f) {
                    yield Direction.DOWN;
                }
                yield null;
            }
            case Direction.UP -> {
                if (this.to.getY() == 1.0f) {
                    yield Direction.UP;
                }
                yield null;
            }
            case Direction.NORTH -> {
                if (this.from.getZ() == 0.0f) {
                    yield Direction.NORTH;
                }
                yield null;
            }
            case Direction.SOUTH -> {
                if (this.to.getZ() == 1.0f) {
                    yield Direction.SOUTH;
                }
                yield null;
            }
            case Direction.EAST -> {
                if (this.to.getX() == 1.0f) {
                    yield Direction.EAST;
                }
                yield null;
            }
            case Direction.WEST -> this.from.getX() == 0.0f ? Direction.WEST : null;
        };
    }

    public Element copy() {
        return new Element(this);
    }

    boolean isFullCube() {
        if (!FULL_BLOCK_MIN.equals((Object)this.from) || !FULL_BLOCK_MAX.equals((Object)this.to)) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (this.faces.containsKey((Object)dir)) continue;
            return false;
        }
        return true;
    }

    public void optimize(ResourcePack resourcePack) {
        for (Face face : this.faces.values()) {
            face.optimize(resourcePack);
        }
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isShade() {
        return this.shade;
    }

    public int getLightEmission() {
        return this.lightEmission;
    }

    public EnumMap<Direction, Face> getFaces() {
        return this.faces;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Element> {
        public Adapter() {
            super(Element.class);
        }

        @Override
        public Element read(JsonReader in, Gson gson) throws IOException {
            Element element = (Element)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Element.class)).read(in);
            element.init();
            return element;
        }
    }
}

