/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate;

import com.google.gson.Gson;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockStateCondition;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.VariantSet;
import de.bluecolored.bluemap.core.world.BlockState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public class Variants {
    private VariantSet[] variants = new VariantSet[0];
    private VariantSet defaultVariant;

    private Variants() {
    }

    public VariantSet[] getVariants() {
        return this.variants;
    }

    @Nullable
    public VariantSet getDefaultVariant() {
        return this.defaultVariant;
    }

    public void forEach(BlockState blockState, int x, int y, int z, Consumer<Variant> consumer) {
        for (VariantSet variant : this.variants) {
            if (!variant.getCondition().matches(blockState)) continue;
            variant.forEach(x, y, z, consumer);
            return;
        }
        if (this.defaultVariant != null) {
            this.defaultVariant.forEach(x, y, z, consumer);
        }
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Variants> {
        public Adapter() {
            super(Variants.class);
        }

        @Override
        public Variants read(JsonReader in, Gson gson) throws IOException {
            VariantSet defaultVariant = null;
            ArrayList<VariantSet> variants = new ArrayList<VariantSet>();
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("__comment")) {
                    in.skipValue();
                    continue;
                }
                BlockStateCondition condition = this.parseConditionString(name);
                VariantSet variantSet = (VariantSet)gson.fromJson(in, VariantSet.class);
                variantSet.setCondition(condition);
                if (variantSet.getCondition() == BlockStateCondition.all()) {
                    defaultVariant = variantSet;
                    continue;
                }
                if (variantSet.getCondition() == BlockStateCondition.none()) continue;
                variants.add(variantSet);
            }
            in.endObject();
            Variants result = new Variants();
            result.defaultVariant = defaultVariant;
            result.variants = (VariantSet[])variants.toArray(VariantSet[]::new);
            return result;
        }

        private BlockStateCondition parseConditionString(String conditionString) {
            ArrayList<BlockStateCondition> conditions = new ArrayList<BlockStateCondition>();
            boolean invalid = false;
            if (!(conditionString.isEmpty() || conditionString.equals("default") || conditionString.equals("normal"))) {
                String[] conditionSplit;
                for (String element : conditionSplit = conditionString.split(",")) {
                    String[] keyval = element.split("=", 2);
                    if (keyval.length < 2) {
                        Logger.global.logDebug("Failed to parse condition: Condition-String '" + conditionString + "' is invalid!");
                        invalid = true;
                        continue;
                    }
                    conditions.add(BlockStateCondition.property(keyval[0], keyval[1]));
                }
            }
            BlockStateCondition condition = conditions.isEmpty() ? (invalid ? BlockStateCondition.none() : BlockStateCondition.all()) : (conditions.size() == 1 ? (BlockStateCondition)conditions.get(0) : BlockStateCondition.and(conditions.toArray(new BlockStateCondition[0])));
            return condition;
        }
    }
}

